/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ribbon.test.resources;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.codehaus.jackson.map.ObjectMapper;
import org.junit.Ignore;

@Ignore
@Path(value="/testAsync")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class EmbeddedResources {
    private static ObjectMapper mapper;
    public static final Person defaultPerson;
    public static final List<String> streamContent;
    public static final List<Person> entityStream;

    @GET
    @Path(value="/person")
    public Response getPerson() throws IOException {
        String content = mapper.writeValueAsString((Object)defaultPerson);
        return Response.ok((Object)content).build();
    }

    @GET
    @Path(value="/context")
    @Produces(value={"text/plain"})
    public Response echoContext(@HeaderParam(value="X-RXNETTY-REQUEST-ID") String requestId) throws IOException {
        return Response.ok((Object)requestId).build();
    }

    @GET
    @Path(value="/noEntity")
    public Response getNoEntity() {
        return Response.ok().build();
    }

    @GET
    @Path(value="/readTimeout")
    public Response getReadTimeout() throws IOException, InterruptedException {
        Thread.sleep(10000L);
        String content = mapper.writeValueAsString((Object)defaultPerson);
        return Response.ok((Object)content).build();
    }

    @POST
    @Path(value="/person")
    public Response createPerson(String content) throws IOException {
        Person person = (Person)mapper.readValue(content, Person.class);
        return Response.ok((Object)mapper.writeValueAsString((Object)person)).build();
    }

    @GET
    @Path(value="/personQuery")
    public Response queryPerson(@QueryParam(value="name") String name, @QueryParam(value="age") int age) throws IOException {
        Person person = new Person(name, age);
        return Response.ok((Object)mapper.writeValueAsString((Object)person)).build();
    }

    @POST
    @Path(value="/postTimeout")
    public Response postWithTimeout(String content) {
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return Response.ok().build();
    }

    @GET
    @Path(value="/throttle")
    public Response throttle() {
        return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)"Rate exceeds limit").build();
    }

    @GET
    @Path(value="/stream")
    @Produces(value={"text/event-stream"})
    public StreamingOutput getStream() {
        return new StreamingOutput(){

            public void write(OutputStream output) throws IOException, WebApplicationException {
                for (String line : streamContent) {
                    String eventLine = line + "\n";
                    output.write(eventLine.getBytes("UTF-8"));
                }
            }
        };
    }

    @GET
    @Path(value="/redirect")
    public Response redirect(@QueryParam(value="port") int port) {
        return Response.status((int)301).header("Location", (Object)("http://localhost:" + port + "/testAsync/person")).build();
    }

    @GET
    @Path(value="/personStream")
    @Produces(value={"text/event-stream"})
    public StreamingOutput getEntityStream() {
        return new StreamingOutput(){

            public void write(OutputStream output) throws IOException, WebApplicationException {
                for (Person person : entityStream) {
                    String eventLine = "data: " + mapper.writeValueAsString((Object)person) + "\n\n";
                    output.write(eventLine.getBytes("UTF-8"));
                }
            }
        };
    }

    static {
        int i;
        mapper = new ObjectMapper();
        defaultPerson = new Person("ribbon", 1);
        streamContent = Lists.newArrayList();
        entityStream = Lists.newArrayList();
        for (i = 0; i < 1000; ++i) {
            streamContent.add("data: line " + i);
        }
        for (i = 0; i < 1000; ++i) {
            entityStream.add(new Person("ribbon", i));
        }
    }

    public static class Person {
        public String name;
        public int age;

        public Person() {
        }

        public Person(String name, int age) {
            this.name = name;
            this.age = age;
        }

        public String toString() {
            return "Person [name=" + this.name + ", age=" + this.age + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.age;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Person other = (Person)obj;
            if (this.age != other.age) {
                return false;
            }
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }
    }
}

