/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.client.netty;

import com.netflix.client.RetryHandler;
import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.IClientConfig;
import com.netflix.client.config.IClientConfigKey;
import com.netflix.client.ssl.AbstractSslContextFactory;
import com.netflix.client.ssl.ClientSslSocketFactoryException;
import com.netflix.client.ssl.URLSslContextFactory;
import com.netflix.loadbalancer.DynamicServerListLoadBalancer;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.LoadBalancerBuilder;
import com.netflix.loadbalancer.LoadBalancerExecutor;
import com.netflix.loadbalancer.LoadBalancerObservableCommand;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ServerListChangeListener;
import io.reactivex.netty.channel.ObservableConnection;
import io.reactivex.netty.client.ClientMetricsEvent;
import io.reactivex.netty.client.RxClient;
import io.reactivex.netty.metrics.MetricEventsListener;
import io.reactivex.netty.metrics.MetricEventsSubject;
import io.reactivex.netty.pipeline.PipelineConfigurator;
import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Subscription;

public abstract class LoadBalancingRxClient<I, O, T extends RxClient<I, O>>
implements RxClient<I, O> {
    private static final Logger logger = LoggerFactory.getLogger(LoadBalancingRxClient.class);
    protected final ConcurrentMap<Server, T> rxClientCache = new ConcurrentHashMap<Server, T>();
    protected final LoadBalancerExecutor lbExecutor;
    protected final PipelineConfigurator<O, I> pipelineConfigurator;
    protected final IClientConfig clientConfig;
    protected final RetryHandler retryHandler;
    protected final AbstractSslContextFactory sslContextFactory;
    protected final MetricEventsListener<? extends ClientMetricsEvent<?>> listener;
    protected final MetricEventsSubject<ClientMetricsEvent<?>> eventSubject;

    public LoadBalancingRxClient(IClientConfig config, RetryHandler retryHandler, PipelineConfigurator<O, I> pipelineConfigurator) {
        this(LoadBalancerBuilder.newBuilder().withClientConfig(config).buildLoadBalancerFromConfigWithReflection(), config, retryHandler, pipelineConfigurator);
    }

    public LoadBalancingRxClient(ILoadBalancer lb, IClientConfig config, RetryHandler retryHandler, PipelineConfigurator<O, I> pipelineConfigurator) {
        this.lbExecutor = new LoadBalancerExecutor(lb, config, retryHandler);
        this.retryHandler = retryHandler;
        this.pipelineConfigurator = pipelineConfigurator;
        this.clientConfig = config;
        this.listener = this.createListener(config.getClientName());
        this.eventSubject = new MetricEventsSubject();
        boolean isSecure = this.getProperty(IClientConfigKey.Keys.IsSecure, null, false);
        if (isSecure) {
            URL trustStoreUrl = this.getResourceForOptionalProperty((IClientConfigKey<String>)CommonClientConfigKey.TrustStore);
            URL keyStoreUrl = this.getResourceForOptionalProperty((IClientConfigKey<String>)CommonClientConfigKey.KeyStore);
            boolean isClientAuthRequired = (Boolean)this.clientConfig.get(IClientConfigKey.Keys.IsClientAuthRequired, (Object)false);
            if (isClientAuthRequired && trustStoreUrl != null && keyStoreUrl != null || !isClientAuthRequired && (trustStoreUrl != null || keyStoreUrl != null)) {
                try {
                    this.sslContextFactory = new URLSslContextFactory(trustStoreUrl, (String)this.clientConfig.get(CommonClientConfigKey.TrustStorePassword), keyStoreUrl, (String)this.clientConfig.get(CommonClientConfigKey.KeyStorePassword));
                }
                catch (ClientSslSocketFactoryException e) {
                    throw new IllegalArgumentException("Unable to configure custom secure socket factory", e);
                }
            } else {
                this.sslContextFactory = null;
            }
        } else {
            this.sslContextFactory = null;
        }
        this.addLoadBalancerListener();
    }

    public IClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public int getResponseTimeOut() {
        int maxRetryNextServer = 0;
        int maxRetrySameServer = 0;
        if (this.retryHandler != null) {
            maxRetryNextServer = this.retryHandler.getMaxRetriesOnNextServer();
            maxRetrySameServer = this.retryHandler.getMaxRetriesOnSameServer();
        } else {
            maxRetryNextServer = (Integer)this.clientConfig.get(IClientConfigKey.Keys.MaxAutoRetriesNextServer, (Object)1);
            maxRetrySameServer = (Integer)this.clientConfig.get(IClientConfigKey.Keys.MaxAutoRetries, (Object)0);
        }
        int readTimeout = this.getProperty(IClientConfigKey.Keys.ReadTimeout, null, 5000);
        int connectTimeout = this.getProperty(IClientConfigKey.Keys.ConnectTimeout, null, 2000);
        return (maxRetryNextServer + 1) * (maxRetrySameServer + 1) * (readTimeout + connectTimeout);
    }

    public int getMaxConcurrentRequests() {
        return -1;
    }

    protected <S> S getProperty(IClientConfigKey<S> key, @Nullable IClientConfig requestConfig, S defaultValue) {
        if (requestConfig != null && requestConfig.get(key) != null) {
            return (S)requestConfig.get(key);
        }
        return (S)this.clientConfig.get(key, defaultValue);
    }

    protected URL getResourceForOptionalProperty(IClientConfigKey<String> configKey) {
        String propValue = (String)this.clientConfig.get(configKey);
        URL result = null;
        if (propValue != null && (result = LoadBalancingRxClient.getResource(propValue)) == null) {
            throw new IllegalArgumentException("No resource found for " + configKey + ": " + propValue);
        }
        return result;
    }

    private static URL getResource(String resourceName) {
        URL url = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader != null) {
            url = loader.getResource(resourceName);
        }
        if (url == null) {
            url = ClassLoader.getSystemResource(resourceName);
        }
        if (url == null) {
            try {
                resourceName = URLDecoder.decode(resourceName, "UTF-8");
                url = new File(resourceName).toURI().toURL();
            }
            catch (Exception e) {
                logger.error("Problem loading resource", (Throwable)e);
            }
        }
        return url;
    }

    private void addLoadBalancerListener() {
        ILoadBalancer lb = this.lbExecutor.getLoadBalancer();
        if (!(lb instanceof DynamicServerListLoadBalancer)) {
            return;
        }
        ((DynamicServerListLoadBalancer)lb).addServerListChangeListener(new ServerListChangeListener(){

            public void serverListChanged(List<Server> oldList, List<Server> newList) {
                for (Server server : LoadBalancingRxClient.this.rxClientCache.keySet()) {
                    if (newList.contains(server)) continue;
                    LoadBalancingRxClient.this.removeClient(server);
                }
            }
        });
    }

    protected abstract T cacheLoadRxClient(Server var1);

    protected T getRxClient(String host, int port) {
        Server server = new Server(host, port);
        Object client = (RxClient)this.rxClientCache.get(server);
        if (client != null) {
            return (T)client;
        }
        client = this.cacheLoadRxClient(server);
        client.subscribe(this.listener);
        client.subscribe(this.eventSubject);
        RxClient old = this.rxClientCache.putIfAbsent(server, client);
        if (old != null) {
            return (T)old;
        }
        return (T)client;
    }

    protected T removeClient(Server server) {
        RxClient client = (RxClient)this.rxClientCache.remove(server);
        client.shutdown();
        return (T)client;
    }

    public Observable<ObservableConnection<O, I>> connect() {
        return this.lbExecutor.create(new LoadBalancerObservableCommand<ObservableConnection<O, I>>(){

            public Observable<ObservableConnection<O, I>> run(Server server) {
                return LoadBalancingRxClient.this.getRxClient(server.getHost(), server.getPort()).connect();
            }
        });
    }

    protected abstract MetricEventsListener<? extends ClientMetricsEvent<?>> createListener(String var1);

    public void shutdown() {
        for (Server server : this.rxClientCache.keySet()) {
            this.removeClient(server);
        }
    }

    public String name() {
        return this.clientConfig.getClientName();
    }

    public Subscription subscribe(MetricEventsListener<? extends ClientMetricsEvent<?>> listener) {
        return this.eventSubject.subscribe(listener);
    }
}

