/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.client.netty.http;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.netflix.client.RequestSpecificRetryHandler;
import com.netflix.client.RetryHandler;
import com.netflix.client.config.DefaultClientConfigImpl;
import com.netflix.client.config.IClientConfig;
import com.netflix.client.config.IClientConfigKey;
import com.netflix.client.netty.LoadBalancingRxClientWithPoolOptions;
import com.netflix.client.netty.http.NettyHttpLoadBalancerErrorHandler;
import com.netflix.client.ssl.ClientSslSocketFactoryException;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.LoadBalancerBuilder;
import com.netflix.loadbalancer.LoadBalancerExecutor;
import com.netflix.loadbalancer.LoadBalancerObservableCommand;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ServerStats;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelOption;
import io.netty.handler.codec.http.HttpMethod;
import io.reactivex.netty.channel.ObservableConnection;
import io.reactivex.netty.client.ClientMetricsEvent;
import io.reactivex.netty.client.PoolLimitDeterminationStrategy;
import io.reactivex.netty.client.RxClient;
import io.reactivex.netty.contexts.RequestCorrelator;
import io.reactivex.netty.contexts.RequestIdProvider;
import io.reactivex.netty.contexts.RxContexts;
import io.reactivex.netty.contexts.http.HttpRequestIdProvider;
import io.reactivex.netty.metrics.MetricEventsListener;
import io.reactivex.netty.pipeline.PipelineConfigurator;
import io.reactivex.netty.pipeline.PipelineConfigurators;
import io.reactivex.netty.pipeline.ssl.DefaultFactories;
import io.reactivex.netty.protocol.http.client.HttpClient;
import io.reactivex.netty.protocol.http.client.HttpClientBuilder;
import io.reactivex.netty.protocol.http.client.HttpClientRequest;
import io.reactivex.netty.protocol.http.client.HttpClientResponse;
import io.reactivex.netty.protocol.text.sse.ServerSentEvent;
import io.reactivex.netty.servo.http.HttpClientListener;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import rx.Observable;

public class NettyHttpClient<I, O>
extends LoadBalancingRxClientWithPoolOptions<HttpClientRequest<I>, HttpClientResponse<O>, HttpClient<I, O>>
implements HttpClient<I, O> {
    protected static final PipelineConfigurator<HttpClientResponse<ByteBuf>, HttpClientRequest<ByteBuf>> DEFAULT_PIPELINE_CONFIGURATOR = PipelineConfigurators.httpClientConfigurator();
    protected static final PipelineConfigurator<HttpClientResponse<ServerSentEvent>, HttpClientRequest<ByteBuf>> DEFAULT_SSE_PIPELINE_CONFIGURATOR = PipelineConfigurators.sseClientConfigurator();
    private String requestIdHeaderName = this.getProperty(IClientConfigKey.Keys.RequestIdHeaderName, null, null);
    private HttpRequestIdProvider requestIdProvider;

    public NettyHttpClient(ILoadBalancer lb, PipelineConfigurator<HttpClientResponse<O>, HttpClientRequest<I>> pipeLineConfigurator, ScheduledExecutorService poolCleanerScheduler) {
        this(lb, (IClientConfig)DefaultClientConfigImpl.getClientConfigWithDefaultValues(), (RetryHandler)new NettyHttpLoadBalancerErrorHandler(), pipeLineConfigurator, poolCleanerScheduler);
    }

    public NettyHttpClient(IClientConfig config, RetryHandler retryHandler, PipelineConfigurator<HttpClientResponse<O>, HttpClientRequest<I>> pipelineConfigurator, ScheduledExecutorService poolCleanerScheduler) {
        this(LoadBalancerBuilder.newBuilder().withClientConfig(config).buildLoadBalancerFromConfigWithReflection(), config, retryHandler, pipelineConfigurator, poolCleanerScheduler);
    }

    public NettyHttpClient(ILoadBalancer lb, IClientConfig config, RetryHandler retryHandler, PipelineConfigurator<HttpClientResponse<O>, HttpClientRequest<I>> pipelineConfigurator, ScheduledExecutorService poolCleanerScheduler) {
        super(lb, config, retryHandler, pipelineConfigurator, poolCleanerScheduler);
        if (this.requestIdHeaderName != null) {
            this.requestIdProvider = new HttpRequestIdProvider(this.requestIdHeaderName, (RequestCorrelator)RxContexts.DEFAULT_CORRELATOR);
        }
    }

    private RequestSpecificRetryHandler getRequestRetryHandler(HttpClientRequest<?> request, IClientConfig requestConfig) {
        boolean okToRetryOnAllErrors = request.getMethod().equals((Object)HttpMethod.GET);
        return new RequestSpecificRetryHandler(true, okToRetryOnAllErrors, this.lbExecutor.getRetryHandler(), requestConfig);
    }

    protected void setHost(HttpClientRequest<?> request, String host) {
        request.getHeaders().set("Host", (Object)host);
    }

    public Observable<HttpClientResponse<O>> submit(String host, int port, HttpClientRequest<I> request) {
        return this.submit(host, port, request, this.getRxClientConfig(null));
    }

    public Observable<HttpClientResponse<O>> submit(String host, int port, HttpClientRequest<I> request, RxClient.ClientConfig rxClientConfig) {
        Preconditions.checkNotNull((Object)host);
        Preconditions.checkNotNull(request);
        HttpClient rxClient = (HttpClient)this.getRxClient(host, port);
        this.setHost(request, host);
        return rxClient.submit(request, rxClientConfig);
    }

    private RxClient.ClientConfig getRxClientConfig(IClientConfig requestConfig) {
        if (requestConfig == null) {
            return HttpClient.HttpClientConfig.Builder.newDefaultConfig();
        }
        int requestReadTimeout = this.getProperty(IClientConfigKey.Keys.ReadTimeout, requestConfig, 5000);
        Boolean followRedirect = this.getProperty(IClientConfigKey.Keys.FollowRedirects, requestConfig, null);
        HttpClient.HttpClientConfig.Builder builder = (HttpClient.HttpClientConfig.Builder)new HttpClient.HttpClientConfig.Builder().readTimeout(requestReadTimeout, TimeUnit.MILLISECONDS);
        if (followRedirect != null) {
            builder.setFollowRedirect(followRedirect.booleanValue());
        }
        return builder.build();
    }

    public Observable<HttpClientResponse<O>> submit(String host, int port, HttpClientRequest<I> request, @Nullable IClientConfig requestConfig) {
        return this.submit(host, port, request, this.getRxClientConfig(requestConfig));
    }

    public Observable<HttpClientResponse<O>> submit(final HttpClientRequest<I> request, RetryHandler errorHandler, IClientConfig requestConfig) {
        RetryHandler retryHandler = errorHandler == null ? this.getRequestRetryHandler(request, requestConfig) : errorHandler;
        final RxClient.ClientConfig rxClientConfig = this.getRxClientConfig(requestConfig);
        Observable<HttpClientResponse<O>> result = this.submitToServerInURI(request, rxClientConfig, retryHandler);
        if (result != null) {
            return result;
        }
        return this.lbExecutor.create(new LoadBalancerObservableCommand<HttpClientResponse<O>>(){

            public Observable<HttpClientResponse<O>> run(Server server) {
                return NettyHttpClient.this.submit(server.getHost(), server.getPort(), request, rxClientConfig);
            }
        }, retryHandler);
    }

    @VisibleForTesting
    ServerStats getServerStats(Server server) {
        return this.lbExecutor.getServerStats(server);
    }

    public Observable<HttpClientResponse<O>> submit(HttpClientRequest<I> request) {
        return this.submit(request, null, null);
    }

    public Observable<HttpClientResponse<O>> submit(final HttpClientRequest<I> request, final RxClient.ClientConfig config) {
        RequestSpecificRetryHandler retryHandler = this.getRequestRetryHandler(request, null);
        Observable<HttpClientResponse<O>> result = this.submitToServerInURI(request, config, (RetryHandler)retryHandler);
        if (result != null) {
            return result;
        }
        return this.lbExecutor.create(new LoadBalancerObservableCommand<HttpClientResponse<O>>(){

            public Observable<HttpClientResponse<O>> run(Server server) {
                return NettyHttpClient.this.submit(server.getHost(), server.getPort(), request, config);
            }
        }, (RetryHandler)retryHandler);
    }

    private Observable<HttpClientResponse<O>> submitToServerInURI(HttpClientRequest<I> request, RxClient.ClientConfig config, RetryHandler errorHandler) {
        URI uri;
        try {
            uri = new URI(request.getUri());
        }
        catch (URISyntaxException e) {
            return Observable.error((Throwable)e);
        }
        String host = uri.getHost();
        if (host == null) {
            return null;
        }
        int port = uri.getPort();
        if (port < 0) {
            port = this.clientConfig.getPropertyAsBoolean(IClientConfigKey.Keys.IsSecure, false) ? 443 : 80;
        }
        if (errorHandler.getMaxRetriesOnSameServer() == 0) {
            return this.submit(host, port, request, config);
        }
        Server server = new Server(host, port);
        return this.lbExecutor.retryWithSameServer(server, this.submit(server.getHost(), server.getPort(), request, config), errorHandler);
    }

    @Override
    public Observable<ObservableConnection<HttpClientResponse<O>, HttpClientRequest<I>>> connect() {
        return this.lbExecutor.create(new LoadBalancerObservableCommand<ObservableConnection<HttpClientResponse<O>, HttpClientRequest<I>>>(){

            public Observable<ObservableConnection<HttpClientResponse<O>, HttpClientRequest<I>>> run(Server server) {
                HttpClient rxClient = (HttpClient)NettyHttpClient.this.getRxClient(server.getHost(), server.getPort());
                return rxClient.connect();
            }
        });
    }

    @Override
    protected HttpClient<I, O> cacheLoadRxClient(Server server) {
        HttpClientBuilder clientBuilder = this.requestIdProvider != null ? RxContexts.newHttpClientBuilder((String)server.getHost(), (int)server.getPort(), (RequestIdProvider)this.requestIdProvider, (RequestCorrelator)RxContexts.DEFAULT_CORRELATOR, (PipelineConfigurator)this.pipelineConfigurator) : RxContexts.newHttpClientBuilder((String)server.getHost(), (int)server.getPort(), (RequestCorrelator)RxContexts.DEFAULT_CORRELATOR, (PipelineConfigurator)this.pipelineConfigurator);
        Integer connectTimeout = this.getProperty(IClientConfigKey.Keys.ConnectTimeout, null, 2000);
        Integer readTimeout = this.getProperty(IClientConfigKey.Keys.ReadTimeout, null, 5000);
        Boolean followRedirect = this.getProperty(IClientConfigKey.Keys.FollowRedirects, null, null);
        HttpClient.HttpClientConfig.Builder builder = (HttpClient.HttpClientConfig.Builder)new HttpClient.HttpClientConfig.Builder().readTimeout(readTimeout.intValue(), TimeUnit.MILLISECONDS);
        if (followRedirect != null) {
            builder.setFollowRedirect(followRedirect.booleanValue());
        }
        RxClient.ClientConfig rxClientConfig = builder.build();
        ((HttpClientBuilder)clientBuilder.channelOption(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)connectTimeout)).config(rxClientConfig);
        if (this.isPoolEnabled()) {
            ((HttpClientBuilder)((HttpClientBuilder)clientBuilder.withConnectionPoolLimitStrategy((PoolLimitDeterminationStrategy)this.poolStrategy)).withIdleConnectionsTimeoutMillis((long)this.idleConnectionEvictionMills)).withPoolIdleCleanupScheduler(this.poolCleanerScheduler);
        } else {
            clientBuilder.withNoConnectionPooling();
        }
        if (this.sslContextFactory != null) {
            try {
                clientBuilder.withSslEngineFactory(DefaultFactories.fromSSLContext((SSLContext)this.sslContextFactory.getSSLContext()));
            }
            catch (ClientSslSocketFactoryException e) {
                throw new RuntimeException(e);
            }
        }
        HttpClient client = (HttpClient)clientBuilder.build();
        return client;
    }

    HttpClientListener getListener() {
        return (HttpClientListener)this.listener;
    }

    LoadBalancerExecutor getLoadBalancerExecutor() {
        return this.lbExecutor;
    }

    @Override
    protected MetricEventsListener<? extends ClientMetricsEvent<?>> createListener(String name) {
        return HttpClientListener.newHttpListener((String)name);
    }
}

