/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.client.netty.http;

import com.netflix.client.RetryHandler;
import com.netflix.client.config.IClientConfig;
import com.netflix.client.config.IClientConfigKey;
import com.netflix.client.netty.http.NettyHttpClient;
import com.netflix.loadbalancer.ILoadBalancer;
import io.netty.channel.ChannelOption;
import io.reactivex.netty.client.RxClient;
import io.reactivex.netty.pipeline.PipelineConfigurator;
import io.reactivex.netty.protocol.http.client.HttpClient;
import io.reactivex.netty.protocol.http.client.HttpClientBuilder;
import io.reactivex.netty.protocol.http.client.HttpClientRequest;
import io.reactivex.netty.protocol.http.client.HttpClientResponse;
import io.reactivex.netty.protocol.text.sse.ServerSentEvent;
import java.util.concurrent.ScheduledExecutorService;

public class SSEClient<I>
extends NettyHttpClient<I, ServerSentEvent> {
    public SSEClient(ILoadBalancer lb, IClientConfig config, RetryHandler retryHandler, PipelineConfigurator<HttpClientResponse<ServerSentEvent>, HttpClientRequest<I>> pipelineConfigurator) {
        super(lb, config, retryHandler, pipelineConfigurator, (ScheduledExecutorService)null);
    }

    public SSEClient(IClientConfig config, RetryHandler retryHandler, PipelineConfigurator<HttpClientResponse<ServerSentEvent>, HttpClientRequest<I>> pipelineConfigurator) {
        super(config, retryHandler, pipelineConfigurator, (ScheduledExecutorService)null);
    }

    public SSEClient(ILoadBalancer lb, PipelineConfigurator<HttpClientResponse<ServerSentEvent>, HttpClientRequest<I>> pipeLineConfigurator) {
        super(lb, pipeLineConfigurator, null);
    }

    @Override
    protected HttpClient<I, ServerSentEvent> getRxClient(String host, int port) {
        HttpClientBuilder clientBuilder = (HttpClientBuilder)new HttpClientBuilder(host, port).pipelineConfigurator(this.pipelineConfigurator);
        int requestConnectTimeout = this.getProperty(IClientConfigKey.Keys.ConnectTimeout, null, 2000);
        RxClient.ClientConfig rxClientConfig = new HttpClient.HttpClientConfig.Builder().build();
        HttpClient client = (HttpClient)((HttpClientBuilder)((HttpClientBuilder)clientBuilder.channelOption(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)requestConnectTimeout)).config(rxClientConfig)).build();
        return client;
    }

    @Override
    public void shutdown() {
    }
}

