/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.client.netty.tcp;

import com.netflix.client.RetryHandler;
import com.netflix.client.config.IClientConfig;
import com.netflix.client.config.IClientConfigKey;
import com.netflix.client.netty.LoadBalancingRxClientWithPoolOptions;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.Server;
import io.netty.channel.ChannelOption;
import io.reactivex.netty.RxNetty;
import io.reactivex.netty.client.ClientBuilder;
import io.reactivex.netty.client.ClientMetricsEvent;
import io.reactivex.netty.client.PoolLimitDeterminationStrategy;
import io.reactivex.netty.client.RxClient;
import io.reactivex.netty.metrics.MetricEventsListener;
import io.reactivex.netty.pipeline.PipelineConfigurator;
import io.reactivex.netty.servo.tcp.TcpClientListener;
import java.util.concurrent.ScheduledExecutorService;

public class LoadBalancingTcpClient<I, O>
extends LoadBalancingRxClientWithPoolOptions<I, O, RxClient<I, O>>
implements RxClient<I, O> {
    public LoadBalancingTcpClient(ILoadBalancer lb, IClientConfig config, RetryHandler retryHandler, PipelineConfigurator<O, I> pipelineConfigurator, ScheduledExecutorService poolCleanerScheduler) {
        super(lb, config, retryHandler, pipelineConfigurator, poolCleanerScheduler);
    }

    public LoadBalancingTcpClient(IClientConfig config, RetryHandler retryHandler, PipelineConfigurator<O, I> pipelineConfigurator, ScheduledExecutorService poolCleanerScheduler) {
        super(config, retryHandler, pipelineConfigurator, poolCleanerScheduler);
    }

    @Override
    protected RxClient<I, O> cacheLoadRxClient(Server server) {
        ClientBuilder builder = RxNetty.newTcpClientBuilder((String)server.getHost(), (int)server.getPort());
        if (this.pipelineConfigurator != null) {
            builder.pipelineConfigurator(this.pipelineConfigurator);
        }
        Integer connectTimeout = this.getProperty(IClientConfigKey.Keys.ConnectTimeout, null, 2000);
        builder.channelOption(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)connectTimeout);
        if (this.isPoolEnabled()) {
            ((ClientBuilder)((ClientBuilder)builder.withConnectionPoolLimitStrategy((PoolLimitDeterminationStrategy)this.poolStrategy)).withIdleConnectionsTimeoutMillis((long)this.idleConnectionEvictionMills)).withPoolIdleCleanupScheduler(this.poolCleanerScheduler);
        } else {
            builder.withNoConnectionPooling();
        }
        RxClient client = builder.build();
        return client;
    }

    @Override
    protected MetricEventsListener<? extends ClientMetricsEvent<?>> createListener(String name) {
        return TcpClientListener.newListener((String)name);
    }
}

