/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.client.netty.udp;

import com.netflix.client.RetryHandler;
import com.netflix.client.config.IClientConfig;
import com.netflix.client.netty.LoadBalancingRxClient;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.Server;
import io.reactivex.netty.RxNetty;
import io.reactivex.netty.client.ClientMetricsEvent;
import io.reactivex.netty.client.RxClient;
import io.reactivex.netty.metrics.MetricEventsListener;
import io.reactivex.netty.pipeline.PipelineConfigurator;
import io.reactivex.netty.protocol.udp.client.UdpClientBuilder;
import io.reactivex.netty.servo.udp.UdpClientListener;

public class LoadBalancingUdpClient<I, O>
extends LoadBalancingRxClient<I, O, RxClient<I, O>>
implements RxClient<I, O> {
    public LoadBalancingUdpClient(IClientConfig config, RetryHandler retryHandler, PipelineConfigurator<O, I> pipelineConfigurator) {
        super(config, retryHandler, pipelineConfigurator);
    }

    public LoadBalancingUdpClient(ILoadBalancer lb, IClientConfig config, RetryHandler retryHandler, PipelineConfigurator<O, I> pipelineConfigurator) {
        super(lb, config, retryHandler, pipelineConfigurator);
    }

    @Override
    protected RxClient<I, O> cacheLoadRxClient(Server server) {
        UdpClientBuilder builder = RxNetty.newUdpClientBuilder((String)server.getHost(), (int)server.getPort());
        if (this.pipelineConfigurator != null) {
            builder.pipelineConfigurator(this.pipelineConfigurator);
        }
        return builder.build();
    }

    @Override
    protected MetricEventsListener<? extends ClientMetricsEvent<?>> createListener(String name) {
        return UdpClientListener.newUdpListener((String)name);
    }
}

