/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ribbon;

import com.netflix.client.config.ClientConfigFactory;
import com.netflix.client.config.IClientConfig;
import com.netflix.client.netty.RibbonTransport;
import io.netty.buffer.ByteBuf;
import io.netty.channel.socket.DatagramPacket;
import io.reactivex.netty.client.RxClient;
import io.reactivex.netty.protocol.http.client.HttpClient;
import javax.inject.Inject;

public abstract class RibbonTransportFactory {
    protected final ClientConfigFactory clientConfigFactory;
    public static final RibbonTransportFactory DEFAULT = new DefaultRibbonTransportFactory(ClientConfigFactory.DEFAULT);

    protected RibbonTransportFactory(ClientConfigFactory clientConfigFactory) {
        this.clientConfigFactory = clientConfigFactory;
    }

    public HttpClient<ByteBuf, ByteBuf> newHttpClient(IClientConfig config) {
        return RibbonTransport.newHttpClient(config);
    }

    public RxClient<ByteBuf, ByteBuf> newTcpClient(IClientConfig config) {
        return RibbonTransport.newTcpClient(config);
    }

    public RxClient<DatagramPacket, DatagramPacket> newUdpClient(IClientConfig config) {
        return RibbonTransport.newUdpClient(config);
    }

    public final HttpClient<ByteBuf, ByteBuf> newHttpClient(String name) {
        IClientConfig config = this.clientConfigFactory.newConfig();
        config.loadProperties(name);
        return this.newHttpClient(config);
    }

    public final RxClient<ByteBuf, ByteBuf> newTcpClient(String name) {
        IClientConfig config = this.clientConfigFactory.newConfig();
        config.loadProperties(name);
        return this.newTcpClient(config);
    }

    public RxClient<DatagramPacket, DatagramPacket> newUdpClient(String name) {
        IClientConfig config = this.clientConfigFactory.newConfig();
        config.loadProperties(name);
        return this.newUdpClient(config);
    }

    public static class DefaultRibbonTransportFactory
    extends RibbonTransportFactory {
        @Inject
        public DefaultRibbonTransportFactory(ClientConfigFactory clientConfigFactory) {
            super(clientConfigFactory);
        }
    }
}

