/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ribbon.transport.netty;

import com.netflix.client.RetryHandler;
import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.DefaultClientConfigImpl;
import com.netflix.client.config.IClientConfig;
import com.netflix.client.config.IClientConfigKey;
import com.netflix.client.ssl.AbstractSslContextFactory;
import com.netflix.client.ssl.ClientSslSocketFactoryException;
import com.netflix.client.ssl.URLSslContextFactory;
import com.netflix.client.util.Resources;
import com.netflix.loadbalancer.BaseLoadBalancer;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.LoadBalancerBuilder;
import com.netflix.loadbalancer.LoadBalancerContext;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ServerListChangeListener;
import com.netflix.loadbalancer.reactive.LoadBalancerCommand;
import com.netflix.loadbalancer.reactive.ServerOperation;
import io.reactivex.netty.channel.ObservableConnection;
import io.reactivex.netty.client.ClientMetricsEvent;
import io.reactivex.netty.client.RxClient;
import io.reactivex.netty.metrics.MetricEventsListener;
import io.reactivex.netty.metrics.MetricEventsSubject;
import io.reactivex.netty.pipeline.PipelineConfigurator;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Subscription;

public abstract class LoadBalancingRxClient<I, O, T extends RxClient<I, O>>
implements RxClient<I, O> {
    private static final Logger logger = LoggerFactory.getLogger(LoadBalancingRxClient.class);
    protected final ConcurrentMap<Server, T> rxClientCache = new ConcurrentHashMap<Server, T>();
    protected final PipelineConfigurator<O, I> pipelineConfigurator;
    protected final IClientConfig clientConfig;
    protected final RetryHandler defaultRetryHandler;
    protected final AbstractSslContextFactory sslContextFactory;
    protected final MetricEventsListener<? extends ClientMetricsEvent<?>> listener;
    protected final MetricEventsSubject<ClientMetricsEvent<?>> eventSubject;
    protected final LoadBalancerContext lbContext;

    public LoadBalancingRxClient(IClientConfig config, RetryHandler defaultRetryHandler, PipelineConfigurator<O, I> pipelineConfigurator) {
        this(LoadBalancerBuilder.newBuilder().withClientConfig(config).buildLoadBalancerFromConfigWithReflection(), config, defaultRetryHandler, pipelineConfigurator);
    }

    public LoadBalancingRxClient(ILoadBalancer lb, IClientConfig config, RetryHandler defaultRetryHandler, PipelineConfigurator<O, I> pipelineConfigurator) {
        this.lbContext = new LoadBalancerContext(lb, config, defaultRetryHandler);
        this.defaultRetryHandler = defaultRetryHandler;
        this.pipelineConfigurator = pipelineConfigurator;
        this.clientConfig = config;
        this.listener = this.createListener(config.getClientName());
        this.eventSubject = new MetricEventsSubject();
        boolean isSecure = this.getProperty(IClientConfigKey.Keys.IsSecure, null, false);
        if (isSecure) {
            URL trustStoreUrl = this.getResourceForOptionalProperty((IClientConfigKey<String>)CommonClientConfigKey.TrustStore);
            URL keyStoreUrl = this.getResourceForOptionalProperty((IClientConfigKey<String>)CommonClientConfigKey.KeyStore);
            boolean isClientAuthRequired = (Boolean)this.clientConfig.get(IClientConfigKey.Keys.IsClientAuthRequired, (Object)false);
            if (isClientAuthRequired && trustStoreUrl != null && keyStoreUrl != null || !isClientAuthRequired && (trustStoreUrl != null || keyStoreUrl != null)) {
                try {
                    this.sslContextFactory = new URLSslContextFactory(trustStoreUrl, (String)this.clientConfig.get(CommonClientConfigKey.TrustStorePassword), keyStoreUrl, (String)this.clientConfig.get(CommonClientConfigKey.KeyStorePassword));
                }
                catch (ClientSslSocketFactoryException e) {
                    throw new IllegalArgumentException("Unable to configure custom secure socket factory", e);
                }
            } else {
                this.sslContextFactory = null;
            }
        } else {
            this.sslContextFactory = null;
        }
        this.addLoadBalancerListener();
    }

    public IClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public int getResponseTimeOut() {
        int maxRetryNextServer = 0;
        int maxRetrySameServer = 0;
        if (this.defaultRetryHandler != null) {
            maxRetryNextServer = this.defaultRetryHandler.getMaxRetriesOnNextServer();
            maxRetrySameServer = this.defaultRetryHandler.getMaxRetriesOnSameServer();
        } else {
            maxRetryNextServer = (Integer)this.clientConfig.get(IClientConfigKey.Keys.MaxAutoRetriesNextServer, (Object)DefaultClientConfigImpl.DEFAULT_MAX_AUTO_RETRIES_NEXT_SERVER);
            maxRetrySameServer = (Integer)this.clientConfig.get(IClientConfigKey.Keys.MaxAutoRetries, (Object)DefaultClientConfigImpl.DEFAULT_MAX_AUTO_RETRIES);
        }
        int readTimeout = this.getProperty(IClientConfigKey.Keys.ReadTimeout, null, DefaultClientConfigImpl.DEFAULT_READ_TIMEOUT);
        int connectTimeout = this.getProperty(IClientConfigKey.Keys.ConnectTimeout, null, DefaultClientConfigImpl.DEFAULT_CONNECT_TIMEOUT);
        return (maxRetryNextServer + 1) * (maxRetrySameServer + 1) * (readTimeout + connectTimeout);
    }

    public int getMaxConcurrentRequests() {
        return -1;
    }

    protected <S> S getProperty(IClientConfigKey<S> key, @Nullable IClientConfig requestConfig, S defaultValue) {
        if (requestConfig != null && requestConfig.get(key) != null) {
            return (S)requestConfig.get(key);
        }
        return (S)this.clientConfig.get(key, defaultValue);
    }

    protected URL getResourceForOptionalProperty(IClientConfigKey<String> configKey) {
        String propValue = (String)this.clientConfig.get(configKey);
        URL result = null;
        if (propValue != null && (result = Resources.getResource((String)propValue)) == null) {
            throw new IllegalArgumentException("No resource found for " + configKey + ": " + propValue);
        }
        return result;
    }

    private void addLoadBalancerListener() {
        if (!(this.lbContext.getLoadBalancer() instanceof BaseLoadBalancer)) {
            return;
        }
        ((BaseLoadBalancer)this.lbContext.getLoadBalancer()).addServerListChangeListener(new ServerListChangeListener(){

            public void serverListChanged(List<Server> oldList, List<Server> newList) {
                HashSet<Server> removedServers = new HashSet<Server>(oldList);
                removedServers.removeAll(newList);
                for (Server server : LoadBalancingRxClient.this.rxClientCache.keySet()) {
                    if (!removedServers.contains(server)) continue;
                    LoadBalancingRxClient.this.removeClient(server);
                }
            }
        });
    }

    protected abstract T createRxClient(Server var1);

    protected T getOrCreateRxClient(Server server) {
        Object client = (RxClient)this.rxClientCache.get(server);
        if (client != null) {
            return (T)client;
        }
        client = this.createRxClient(server);
        client.subscribe(this.listener);
        client.subscribe(this.eventSubject);
        RxClient old = this.rxClientCache.putIfAbsent(server, client);
        if (old != null) {
            return (T)old;
        }
        return (T)client;
    }

    protected T removeClient(Server server) {
        RxClient client = (RxClient)this.rxClientCache.remove(server);
        if (client != null) {
            client.shutdown();
        }
        return (T)client;
    }

    public Observable<ObservableConnection<O, I>> connect() {
        return LoadBalancerCommand.builder().withLoadBalancerContext(this.lbContext).build().submit(new ServerOperation<ObservableConnection<O, I>>(){

            public Observable<ObservableConnection<O, I>> call(Server server) {
                return LoadBalancingRxClient.this.getOrCreateRxClient(server).connect();
            }
        });
    }

    protected abstract MetricEventsListener<? extends ClientMetricsEvent<?>> createListener(String var1);

    public void shutdown() {
        for (Server server : this.rxClientCache.keySet()) {
            this.removeClient(server);
        }
    }

    public String name() {
        return this.clientConfig.getClientName();
    }

    public Subscription subscribe(MetricEventsListener<? extends ClientMetricsEvent<?>> listener) {
        return this.eventSubject.subscribe(listener);
    }

    public final LoadBalancerContext getLoadBalancerContext() {
        return this.lbContext;
    }
}

