/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ribbon.transport.netty.http;

import com.netflix.client.config.DefaultClientConfigImpl;
import com.netflix.client.config.IClientConfigKey;
import com.netflix.loadbalancer.Server;
import com.netflix.ribbon.transport.netty.http.LoadBalancingHttpClient;
import io.netty.channel.ChannelOption;
import io.reactivex.netty.client.RxClient;
import io.reactivex.netty.protocol.http.client.HttpClient;
import io.reactivex.netty.protocol.http.client.HttpClientBuilder;
import io.reactivex.netty.protocol.text.sse.ServerSentEvent;
import rx.functions.Func1;

public class SSEClient<I>
extends LoadBalancingHttpClient<I, ServerSentEvent> {
    public static <I> LoadBalancingHttpClient.Builder<I, ServerSentEvent> sseClientBuilder() {
        return new LoadBalancingHttpClient.Builder(new Func1<LoadBalancingHttpClient.Builder<I, ServerSentEvent>, LoadBalancingHttpClient<I, ServerSentEvent>>(){

            public LoadBalancingHttpClient<I, ServerSentEvent> call(LoadBalancingHttpClient.Builder<I, ServerSentEvent> t1) {
                return new SSEClient(t1);
            }
        });
    }

    private SSEClient(LoadBalancingHttpClient.Builder<I, ServerSentEvent> t1) {
        super(t1);
    }

    @Override
    protected HttpClient<I, ServerSentEvent> getOrCreateRxClient(Server server) {
        HttpClientBuilder clientBuilder = (HttpClientBuilder)new HttpClientBuilder(server.getHost(), server.getPort()).pipelineConfigurator(this.pipelineConfigurator);
        int requestConnectTimeout = this.getProperty(IClientConfigKey.Keys.ConnectTimeout, null, DefaultClientConfigImpl.DEFAULT_CONNECT_TIMEOUT);
        RxClient.ClientConfig rxClientConfig = new HttpClient.HttpClientConfig.Builder().build();
        HttpClient client = (HttpClient)((HttpClientBuilder)((HttpClientBuilder)clientBuilder.channelOption(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)requestConnectTimeout)).config(rxClientConfig)).build();
        return client;
    }

    @Override
    public void shutdown() {
    }
}

