/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.runtime.health.api;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public final class Health {
    public static final String ERROR_KEY = "error";
    public static final String CACHE_KEY = "cached";
    public static final String NAME_KEY = "className";
    private final Map<String, Object> details;
    private final boolean isHealthy;

    private Health(boolean isHealthy) {
        this.isHealthy = isHealthy;
        this.details = new LinkedHashMap<String, Object>();
    }

    private Health(boolean isHealthy, Map<String, Object> details) {
        this.isHealthy = isHealthy;
        this.details = new LinkedHashMap<String, Object>(details);
    }

    private Health(Health health) {
        this.isHealthy = health.isHealthy();
        this.details = health.getDetails();
    }

    public Map<String, Object> getDetails() {
        return this.details;
    }

    public boolean isHealthy() {
        return this.isHealthy;
    }

    public Optional<String> getErrorMessage() {
        return Optional.ofNullable((String)this.getDetails().get(ERROR_KEY));
    }

    public static Builder healthy() {
        return Health.from(new Health(true));
    }

    public static Builder unhealthy(Throwable ex) {
        return Health.unhealthy().withException(ex);
    }

    public static Builder unhealthy() {
        return Health.from(new Health(false));
    }

    public static Builder from(Health health) {
        return new Builder(health);
    }

    private static void assertNotNull(Object test, String message) {
        if (test == null) {
            throw new IllegalArgumentException(message);
        }
    }

    private static void assertNotReservedKey(Object key, String message) {
        if (ERROR_KEY.equals(key)) {
            throw new IllegalArgumentException(message);
        }
    }

    public String toString() {
        return "Health [details=" + this.details + ", isHealthy=" + this.isHealthy + "]";
    }

    public static class Builder {
        private final boolean isHealthy;
        private final Map<String, Object> details;

        private Builder(Health health) {
            Health.assertNotNull(health, "Health must not be null");
            this.isHealthy = health.isHealthy();
            this.details = health.getDetails();
        }

        public Builder withException(Throwable ex) {
            Health.assertNotNull(ex, "Exception must not be null");
            this.details.put(Health.ERROR_KEY, ex.getClass().getName() + ": " + ex.getMessage());
            return this;
        }

        public Builder withDetail(String key, Object data) {
            Health.assertNotNull(key, "Key must not be null");
            Health.assertNotNull(data, "Data must not be null");
            Health.assertNotReservedKey(key, "\"" + key + "\" is a reserved key and may not be overridden");
            this.details.put(key, data);
            return this;
        }

        public Health build() {
            return new Health(this.isHealthy, this.details);
        }
    }
}

