/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.runtime.health.api;

import com.netflix.runtime.health.api.Health;
import java.util.ArrayList;
import java.util.List;

public class HealthCheckStatus {
    private final boolean isHealthy;
    private final List<Health> healthResults;
    private final List<Health> suppressedHealthResults;

    public HealthCheckStatus(boolean isHealthy, List<Health> indicators) {
        this.isHealthy = isHealthy;
        this.healthResults = new ArrayList<Health>(indicators);
        this.suppressedHealthResults = new ArrayList<Health>();
    }

    public HealthCheckStatus(boolean isHealthy, List<Health> indicators, List<Health> suppressedIndicators) {
        this.isHealthy = isHealthy;
        this.healthResults = new ArrayList<Health>(indicators);
        this.suppressedHealthResults = new ArrayList<Health>(suppressedIndicators);
    }

    public boolean isHealthy() {
        return this.isHealthy;
    }

    public List<Health> getHealthResults() {
        return this.healthResults;
    }

    public List<Health> getSuppressedHealthResults() {
        return this.suppressedHealthResults;
    }

    public static HealthCheckStatus create(boolean isHealthy, List<Health> indicators) {
        return new HealthCheckStatus(isHealthy, indicators);
    }

    public static HealthCheckStatus create(boolean isHealthy, List<Health> indicators, List<Health> suppressedIndicators) {
        return new HealthCheckStatus(isHealthy, indicators, suppressedIndicators);
    }

    public String toString() {
        return "HealthCheckStatus[isHealthy=" + this.isHealthy + ", indicators=" + this.healthResults + ", + suppressedIndicators=" + this.suppressedHealthResults + "]";
    }
}

