/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.runtime.health.api;

import com.netflix.runtime.health.api.IndicatorMatcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class IndicatorMatchers {
    public static IndicatorMatcherBuilder includes(String ... indicatorNames) {
        return new IndicatorMatcherBuilder().includes(indicatorNames);
    }

    public static IndicatorMatcherBuilder excludes(String ... indicatorNames) {
        return new IndicatorMatcherBuilder().excludes(indicatorNames);
    }

    public static IndicatorMatcher build() {
        return unused -> true;
    }

    public static class IndicatorMatcherBuilder {
        public final List<String> includedIndicatorNames = new ArrayList<String>();
        public final List<String> excludedIndicatorNames = new ArrayList<String>();

        public IndicatorMatcherBuilder includes(String ... indicatorNames) {
            if (indicatorNames != null) {
                this.includedIndicatorNames.addAll(Arrays.asList(indicatorNames));
            }
            return this;
        }

        public IndicatorMatcherBuilder excludes(String ... indicatorNames) {
            if (indicatorNames != null) {
                this.excludedIndicatorNames.addAll(Arrays.asList(indicatorNames));
            }
            return this;
        }

        public IndicatorMatcher build() {
            return indicator -> {
                if (!this.excludedIndicatorNames.stream().noneMatch(i -> indicator.getName().equals(i))) return false;
                if (this.includedIndicatorNames.isEmpty()) return true;
                if (!this.includedIndicatorNames.stream().anyMatch(indicator.getName()::equals)) return false;
                return true;
            };
        }
    }
}

