/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.runtime.health.eureka;

import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.HealthCheckHandler;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.StatusChangeEvent;
import com.netflix.governator.event.ApplicationEvent;
import com.netflix.governator.event.ApplicationEventDispatcher;
import com.netflix.governator.event.ApplicationEventListener;
import com.netflix.governator.spi.LifecycleListener;
import com.netflix.runtime.health.api.HealthCheckAggregator;
import com.netflix.runtime.health.api.HealthCheckStatus;
import com.netflix.runtime.health.api.IndicatorMatcher;
import com.netflix.runtime.health.core.HealthCheckStatusChangedEvent;
import com.netflix.runtime.health.eureka.HealthAggregatorEurekaHealthCheckHandler;
import java.util.concurrent.ExecutionException;
import javax.annotation.PostConstruct;

public class EurekaHealthStatusBridgeModule
extends AbstractModule {
    protected void configure() {
        this.bind(ApplicationEventListener.class).to(EurekaHealthStatusInformingApplicationEventListener.class).asEagerSingleton();
    }

    public boolean equals(Object obj) {
        return obj != null && ((Object)((Object)this)).getClass().equals(obj.getClass());
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }

    private static class EurekaHealthStatusInformingApplicationEventListener
    implements ApplicationEventListener<HealthCheckStatusChangedEvent>,
    LifecycleListener {
        @Inject(optional=true)
        private Provider<ApplicationEventDispatcher> eventDispatcher;
        @javax.inject.Inject
        private Provider<ApplicationInfoManager> applicationInfoManager;
        @javax.inject.Inject
        private Provider<HealthCheckAggregator> healthCheckAggregator;
        @javax.inject.Inject
        private Provider<EurekaClient> eurekaClient;
        @Inject(optional=true)
        private IndicatorMatcher matcher;

        private EurekaHealthStatusInformingApplicationEventListener() {
        }

        @PostConstruct
        public void init() throws InterruptedException, ExecutionException {
            if (this.eventDispatcher != null) {
                ((ApplicationInfoManager)this.applicationInfoManager.get()).registerStatusChangeListener(new ApplicationInfoManager.StatusChangeListener(){

                    public void notify(StatusChangeEvent statusChangeEvent) {
                        ((ApplicationEventDispatcher)eventDispatcher.get()).publishEvent((ApplicationEvent)new EurekaStatusChangeEvent(statusChangeEvent));
                    }

                    public String getId() {
                        return "eurekaHealthStatusBridgeModuleStatusChangeListener";
                    }
                });
            }
        }

        public void onStarted() {
            ((EurekaClient)this.eurekaClient.get()).registerHealthCheck((HealthCheckHandler)new HealthAggregatorEurekaHealthCheckHandler((HealthCheckAggregator)this.healthCheckAggregator.get(), this.matcher));
        }

        public void onStopped(Throwable error) {
        }

        public void onEvent(HealthCheckStatusChangedEvent event) {
            ((ApplicationInfoManager)this.applicationInfoManager.get()).getInfo().setStatus(this.getInstanceStatusForHealth(event.getHealth()));
        }

        private InstanceInfo.InstanceStatus getInstanceStatusForHealth(HealthCheckStatus health) {
            if (health.isHealthy()) {
                return InstanceInfo.InstanceStatus.UP;
            }
            return InstanceInfo.InstanceStatus.DOWN;
        }

        private static class EurekaStatusChangeEvent
        extends StatusChangeEvent
        implements ApplicationEvent {
            public EurekaStatusChangeEvent(StatusChangeEvent event) {
                this(event.getPreviousStatus(), event.getStatus());
            }

            public EurekaStatusChangeEvent(InstanceInfo.InstanceStatus previous, InstanceInfo.InstanceStatus current) {
                super(previous, current);
            }
        }
    }
}

