/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.runtime.health.eureka;

import com.netflix.appinfo.HealthCheckHandler;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.runtime.health.api.HealthCheckAggregator;
import com.netflix.runtime.health.api.HealthCheckStatus;
import com.netflix.runtime.health.api.IndicatorMatcher;

public class HealthAggregatorEurekaHealthCheckHandler
implements HealthCheckHandler {
    private final HealthCheckAggregator healthCheckAggregator;
    private final IndicatorMatcher matcher;

    public HealthAggregatorEurekaHealthCheckHandler(HealthCheckAggregator healthCheckAggregator, IndicatorMatcher matcher) {
        this.healthCheckAggregator = healthCheckAggregator;
        this.matcher = matcher;
    }

    public InstanceInfo.InstanceStatus getStatus(InstanceInfo.InstanceStatus currentStatus) {
        try {
            if (this.matcher != null) {
                return this.getInstanceStatusForHealth((HealthCheckStatus)this.healthCheckAggregator.check(this.matcher).get());
            }
            return this.getInstanceStatusForHealth((HealthCheckStatus)this.healthCheckAggregator.check().get());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private InstanceInfo.InstanceStatus getInstanceStatusForHealth(HealthCheckStatus health) {
        if (health.isHealthy()) {
            return InstanceInfo.InstanceStatus.UP;
        }
        return InstanceInfo.InstanceStatus.DOWN;
    }
}

