/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.runtime.health.servlet;

import com.google.inject.Inject;
import com.netflix.runtime.health.api.HealthCheckAggregator;
import com.netflix.runtime.health.api.HealthCheckStatus;
import com.netflix.runtime.health.api.IndicatorMatcher;
import java.io.IOException;
import javax.inject.Singleton;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Singleton
public final class HealthStatusServlet
extends HttpServlet {
    private static final long serialVersionUID = -6518168654611266480L;
    @javax.inject.Inject
    private HealthCheckAggregator healthCheckAggregator;
    @Inject(optional=true)
    private IndicatorMatcher matcher;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        HealthCheckStatus health;
        try {
            health = this.matcher != null ? (HealthCheckStatus)this.healthCheckAggregator.check(this.matcher).get() : (HealthCheckStatus)this.healthCheckAggregator.check().get();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        if (health.isHealthy()) {
            resp.setStatus(200);
        } else {
            resp.setStatus(500);
        }
        String content = health.toString();
        resp.setContentLength(content.length());
        resp.setContentType("text/plain");
        resp.getWriter().print(content);
    }
}

