/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.publish.atlas;

import com.fasterxml.jackson.core.JsonGenerator;
import com.netflix.servo.Metric;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.tag.Tag;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public final class ValidCharacters {
    private static final boolean[] CHARS_ALLOWED;
    private static final boolean[] CHARS_ALLOWED_GROUPS;
    private static final List<String> RELAXED_GROUP_KEYS;

    private ValidCharacters() {
    }

    private static boolean hasInvalidCharactersTable(boolean[] table, String str) {
        int n = str.length();
        for (int i = 0; i < n; ++i) {
            char c = str.charAt(i);
            if (c < table.length && table[c]) continue;
            return true;
        }
        return false;
    }

    public static boolean hasInvalidCharacters(String str) {
        return ValidCharacters.hasInvalidCharactersTable(CHARS_ALLOWED, str);
    }

    private static String toValidCharsetTable(boolean[] table, String str) {
        if (ValidCharacters.hasInvalidCharactersTable(table, str)) {
            int n = str.length();
            StringBuilder buf = new StringBuilder(n + 1);
            for (int i = 0; i < n; ++i) {
                char c = str.charAt(i);
                if (c < table.length && table[c]) {
                    buf.append(c);
                    continue;
                }
                buf.append('_');
            }
            return buf.toString();
        }
        return str;
    }

    public static String toValidCharset(String str) {
        return ValidCharacters.toValidCharsetTable(CHARS_ALLOWED, str);
    }

    public static Metric toValidValue(Metric metric) {
        MonitorConfig cfg = metric.getConfig();
        MonitorConfig.Builder cfgBuilder = MonitorConfig.builder((String)ValidCharacters.toValidCharset(cfg.getName()));
        for (Tag orig : cfg.getTags()) {
            String key = orig.getKey();
            if (RELAXED_GROUP_KEYS.contains(key)) {
                cfgBuilder.withTag(key, ValidCharacters.toValidCharsetTable(CHARS_ALLOWED_GROUPS, orig.getValue()));
                continue;
            }
            cfgBuilder.withTag(ValidCharacters.toValidCharset(key), ValidCharacters.toValidCharset(orig.getValue()));
        }
        cfgBuilder.withPublishingPolicy(cfg.getPublishingPolicy());
        return new Metric(cfgBuilder.build(), metric.getTimestamp(), metric.getValue());
    }

    public static List<Metric> toValidValues(List<Metric> metrics) {
        return metrics.stream().map(ValidCharacters::toValidValue).collect(Collectors.toList());
    }

    public static void tagToJson(JsonGenerator gen, Tag tag) throws IOException {
        String key = tag.getKey();
        if (RELAXED_GROUP_KEYS.contains(key)) {
            gen.writeStringField(key, ValidCharacters.toValidCharsetTable(CHARS_ALLOWED_GROUPS, tag.getValue()));
        } else {
            gen.writeStringField(ValidCharacters.toValidCharset(tag.getKey()), ValidCharacters.toValidCharset(tag.getValue()));
        }
    }

    static {
        int ch;
        CHARS_ALLOWED = new boolean[128];
        CHARS_ALLOWED_GROUPS = new boolean[128];
        ValidCharacters.CHARS_ALLOWED[46] = true;
        ValidCharacters.CHARS_ALLOWED[45] = true;
        ValidCharacters.CHARS_ALLOWED[95] = true;
        for (ch = 48; ch <= 57; ch = (int)((char)(ch + 1))) {
            ValidCharacters.CHARS_ALLOWED[ch] = true;
        }
        for (ch = 65; ch <= 90; ch = (int)((char)(ch + 1))) {
            ValidCharacters.CHARS_ALLOWED[ch] = true;
        }
        for (ch = 97; ch <= 122; ch = (int)((char)(ch + 1))) {
            ValidCharacters.CHARS_ALLOWED[ch] = true;
        }
        System.arraycopy(CHARS_ALLOWED, 0, CHARS_ALLOWED_GROUPS, 0, CHARS_ALLOWED.length);
        ValidCharacters.CHARS_ALLOWED_GROUPS[94] = true;
        ValidCharacters.CHARS_ALLOWED_GROUPS[126] = true;
        RELAXED_GROUP_KEYS = Arrays.asList("nf.asg", "nf.cluster");
    }
}

