/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicLong;

final class DefaultCounter
implements Counter {
    private final Clock clock;
    private final Id id;
    private final AtomicLong count;

    DefaultCounter(Clock clock, Id id) {
        this.clock = clock;
        this.id = id;
        this.count = new AtomicLong(0L);
    }

    @Override
    public Id id() {
        return this.id;
    }

    @Override
    public boolean hasExpired() {
        return false;
    }

    @Override
    public Iterable<Measurement> measure() {
        long now = this.clock.wallTime();
        long v = this.count.get();
        return Collections.singleton(new Measurement(this.id, now, v));
    }

    @Override
    public void increment() {
        this.count.incrementAndGet();
    }

    @Override
    public void increment(long amount) {
        this.count.addAndGet(amount);
    }

    @Override
    public long count() {
        return this.count.get();
    }
}

