/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api;

import com.netflix.spectator.api.DefaultRegistry;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Meter;
import com.netflix.spectator.api.Registry;
import java.util.ArrayList;

class RegistryMeter
implements Meter {
    private final Id id;
    private final Registry registry;

    RegistryMeter(Id id) {
        this(id, new DefaultRegistry());
    }

    RegistryMeter(Id id, Registry registry) {
        this.id = id;
        this.registry = registry;
    }

    void register(Meter meter) {
        this.registry.register(meter);
    }

    @Override
    public Id id() {
        return this.id;
    }

    @Override
    public Iterable<Measurement> measure() {
        ArrayList<Measurement> ms = new ArrayList<Measurement>();
        for (Meter m : this.registry) {
            try {
                for (Measurement measurement : m.measure()) {
                    ms.add(measurement);
                }
            }
            catch (Exception | LinkageError e) {
                this.registry.propagate("failed to measure " + m.id(), e);
            }
        }
        return ms;
    }

    @Override
    public boolean hasExpired() {
        return false;
    }
}

