/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.CompositeMeter;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Timer;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

final class CompositeTimer
extends CompositeMeter<Timer>
implements Timer {
    private final Clock clock;

    CompositeTimer(Id id, Clock clock, Collection<Timer> timers) {
        super(id, timers);
        this.clock = clock;
    }

    @Override
    public void record(long amount, TimeUnit unit) {
        for (Timer t : this.meters) {
            t.record(amount, unit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T record(Callable<T> f) throws Exception {
        long s = this.clock.monotonicTime();
        try {
            T t = f.call();
            return t;
        }
        finally {
            long e = this.clock.monotonicTime();
            this.record(e - s, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void record(Runnable f) {
        long s = this.clock.monotonicTime();
        try {
            f.run();
        }
        finally {
            long e = this.clock.monotonicTime();
            this.record(e - s, TimeUnit.NANOSECONDS);
        }
    }

    @Override
    public long count() {
        Iterator it = this.meters.iterator();
        return it.hasNext() ? ((Timer)it.next()).count() : 0L;
    }

    @Override
    public long totalTime() {
        Iterator it = this.meters.iterator();
        return it.hasNext() ? ((Timer)it.next()).totalTime() : 0L;
    }
}

