/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.impl;

import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.impl.Cache;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

class LfuCache<K, V>
implements Cache<K, V> {
    private final Counter hits;
    private final Counter misses;
    private final Counter compactions;
    private final ConcurrentHashMap<K, Pair<V>> data;
    private final int baseSize;
    private final int compactionSize;
    private final PriorityQueue<Snapshot<K>> mostFrequentItems;
    private final List<K> mostFrequentKeys;
    private final AtomicInteger size;
    private final Lock lock;
    private static final Comparator<Snapshot<?>> SNAPSHOT_COMPARATOR = (a, b) -> Long.compare(b.count(), a.count());

    LfuCache(Registry registry, String id, int baseSize, int compactionSize) {
        this.hits = registry.counter("spectator.cache.requests", "id", id, "result", "hit");
        this.misses = registry.counter("spectator.cache.requests", "id", id, "result", "miss");
        this.compactions = registry.counter("spectator.cache.compactions", "id", id);
        this.data = new ConcurrentHashMap();
        this.baseSize = baseSize;
        this.compactionSize = compactionSize;
        this.mostFrequentItems = new PriorityQueue(baseSize, SNAPSHOT_COMPARATOR);
        this.mostFrequentKeys = new ArrayList<K>(baseSize);
        this.size = new AtomicInteger();
        this.lock = new ReentrantLock();
    }

    private void addIfMoreFrequent(K key, Pair<V> value) {
        long count = value.snapshot();
        if (this.mostFrequentItems.size() >= this.baseSize) {
            Snapshot<K> leastFrequentItem = this.mostFrequentItems.peek();
            if (leastFrequentItem != null && count > leastFrequentItem.count()) {
                this.mostFrequentItems.poll();
                this.mostFrequentItems.offer(new Snapshot<K>(key, count));
            }
        } else {
            this.mostFrequentItems.offer(new Snapshot<K>(key, count));
        }
    }

    private void compact() {
        int numToRemove = this.size.get() - this.baseSize;
        if (numToRemove > 0) {
            this.mostFrequentItems.clear();
            this.mostFrequentKeys.clear();
            this.data.forEach(this::addIfMoreFrequent);
            this.mostFrequentItems.forEach((Consumer<Snapshot<K>>)((Consumer<Snapshot>)s -> this.mostFrequentKeys.add(s.get())));
            ((ConcurrentHashMap.CollectionView)((Object)this.data.keySet())).retainAll(this.mostFrequentKeys);
            this.size.set(this.data.size());
            this.compactions.increment();
        }
    }

    private void tryCompact() {
        if (this.lock.tryLock()) {
            try {
                this.compact();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @Override
    public V get(K key) {
        Pair<V> value = this.data.get(key);
        if (value == null) {
            this.misses.increment();
            return null;
        }
        this.hits.increment();
        return value.get();
    }

    @Override
    public V peek(K key) {
        Pair<V> value = this.data.get(key);
        return value == null ? null : (V)value.peek();
    }

    @Override
    public void put(K key, V value) {
        Pair<V> prev = this.data.put(key, new Pair<V>(value));
        if (prev == null && this.size.incrementAndGet() > this.compactionSize) {
            this.tryCompact();
        }
    }

    @Override
    public V computeIfAbsent(K key, Function<K, V> f) {
        Pair<V> value = this.data.get(key);
        if (value == null) {
            this.misses.increment();
            Pair<V> tmp = new Pair<V>(f.apply(key));
            value = this.data.putIfAbsent(key, tmp);
            if (value == null) {
                value = tmp;
                if (this.size.incrementAndGet() > this.compactionSize) {
                    this.tryCompact();
                }
            }
        } else {
            this.hits.increment();
        }
        return value.get();
    }

    @Override
    public void clear() {
        this.size.set(0);
        this.data.clear();
    }

    @Override
    public int size() {
        return this.size.get();
    }

    @Override
    public Map<K, V> asMap() {
        return this.data.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Pair)e.getValue()).peek()));
    }

    private static class Snapshot<K> {
        private final K key;
        private final long count;

        Snapshot(K key, long count) {
            this.key = key;
            this.count = count;
        }

        K get() {
            return this.key;
        }

        long count() {
            return this.count;
        }
    }

    private static class Pair<V> {
        private final V value;
        private final LongAdder count;

        Pair(V value) {
            this.value = value;
            this.count = new LongAdder();
        }

        V get() {
            this.count.increment();
            return this.value;
        }

        V peek() {
            return this.value;
        }

        long snapshot() {
            return this.count.sum();
        }
    }
}

