/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.impl;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.impl.StepValue;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class StepLong
implements StepValue {
    private final long init;
    private final Clock clock;
    private final long step;
    private volatile long previous;
    private volatile long current;
    private static final AtomicLongFieldUpdater<StepLong> CURRENT_UPDATER = AtomicLongFieldUpdater.newUpdater(StepLong.class, "current");
    private volatile long lastInitPos;
    private static final AtomicLongFieldUpdater<StepLong> LAST_INIT_POS_UPDATER = AtomicLongFieldUpdater.newUpdater(StepLong.class, "lastInitPos");

    public StepLong(long init, Clock clock, long step) {
        this.init = init;
        this.clock = clock;
        this.step = step;
        this.previous = init;
        this.current = init;
        this.lastInitPos = clock.wallTime() / step;
    }

    private void rollCount(long now) {
        long lastInit = this.lastInitPos;
        long stepTime = now / this.step;
        if (lastInit < stepTime && LAST_INIT_POS_UPDATER.compareAndSet(this, lastInit, stepTime)) {
            long v = CURRENT_UPDATER.getAndSet(this, this.init);
            this.previous = lastInit == stepTime - 1L ? v : this.init;
        }
    }

    public long getCurrent() {
        return this.getCurrent(this.clock.wallTime());
    }

    public long getCurrent(long now) {
        this.rollCount(now);
        return this.current;
    }

    public void setCurrent(long now, long value) {
        this.rollCount(now);
        this.current = value;
    }

    public long incrementAndGet(long now) {
        this.rollCount(now);
        return CURRENT_UPDATER.incrementAndGet(this);
    }

    public long getAndIncrement(long now) {
        this.rollCount(now);
        return CURRENT_UPDATER.getAndIncrement(this);
    }

    public long addAndGet(long now, long value) {
        this.rollCount(now);
        return CURRENT_UPDATER.addAndGet(this, value);
    }

    public long getAndAdd(long now, long value) {
        this.rollCount(now);
        return CURRENT_UPDATER.getAndAdd(this, value);
    }

    public long getAndSet(long now, long value) {
        this.rollCount(now);
        return CURRENT_UPDATER.getAndSet(this, value);
    }

    public boolean compareAndSet(long now, long expect, long update) {
        this.rollCount(now);
        return CURRENT_UPDATER.compareAndSet(this, expect, update);
    }

    public void min(long now, long value) {
        this.rollCount(now);
        long min = this.current;
        while (value < min && !CURRENT_UPDATER.compareAndSet(this, min, value)) {
            min = this.current;
        }
    }

    public void max(long now, long value) {
        this.rollCount(now);
        long max = this.current;
        while (value > max && !CURRENT_UPDATER.compareAndSet(this, max, value)) {
            max = this.current;
        }
    }

    public long poll() {
        return this.poll(this.clock.wallTime());
    }

    public long poll(long now) {
        this.rollCount(now);
        return this.previous;
    }

    @Override
    public double pollAsRate() {
        return this.pollAsRate(this.clock.wallTime());
    }

    @Override
    public double pollAsRate(long now) {
        long amount = this.poll(now);
        double period = (double)this.step / 1000.0;
        return (double)amount / period;
    }

    @Override
    public long timestamp() {
        return this.lastInitPos * this.step;
    }

    public String toString() {
        return "StepLong{init=" + this.init + ", previous=" + this.previous + ", current=" + this.current + ", lastInitPos=" + this.lastInitPos + '}';
    }
}

