/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.ipc;

import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.DistributionSummary;
import com.netflix.spectator.api.Gauge;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.api.Timer;
import com.netflix.spectator.api.Utils;
import com.netflix.spectator.ipc.IpcAttempt;
import com.netflix.spectator.ipc.IpcFailureInjection;
import com.netflix.spectator.ipc.IpcResult;
import com.netflix.spectator.ipc.IpcStatus;
import com.netflix.spectator.ipc.IpcTagKey;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;

public enum IpcMetric {
    clientCall("ipc.client.call", EnumSet.of(IpcTagKey.attempt, IpcTagKey.attemptFinal, IpcTagKey.owner, IpcTagKey.result, IpcTagKey.status), EnumSet.of(IpcTagKey.endpoint, new IpcTagKey[]{IpcTagKey.failureInjected, IpcTagKey.httpMethod, IpcTagKey.httpStatus, IpcTagKey.id, IpcTagKey.protocol, IpcTagKey.serverApp, IpcTagKey.serverCluster, IpcTagKey.serverAsg, IpcTagKey.statusDetail, IpcTagKey.vip})),
    serverCall("ipc.server.call", EnumSet.of(IpcTagKey.owner, IpcTagKey.result, IpcTagKey.status), EnumSet.of(IpcTagKey.endpoint, new IpcTagKey[]{IpcTagKey.clientApp, IpcTagKey.clientCluster, IpcTagKey.clientAsg, IpcTagKey.failureInjected, IpcTagKey.httpMethod, IpcTagKey.httpStatus, IpcTagKey.id, IpcTagKey.protocol, IpcTagKey.statusDetail, IpcTagKey.vip})),
    clientInflight("ipc.client.inflight", EnumSet.of(IpcTagKey.owner), EnumSet.of(IpcTagKey.endpoint, new IpcTagKey[]{IpcTagKey.id, IpcTagKey.protocol, IpcTagKey.serverApp, IpcTagKey.serverCluster, IpcTagKey.serverAsg, IpcTagKey.vip})),
    serverInflight("ipc.server.inflight", EnumSet.of(IpcTagKey.owner), EnumSet.of(IpcTagKey.clientApp, new IpcTagKey[]{IpcTagKey.clientCluster, IpcTagKey.clientAsg, IpcTagKey.endpoint, IpcTagKey.id, IpcTagKey.protocol, IpcTagKey.vip}));

    private final String metricName;
    private final EnumSet<IpcTagKey> requiredDimensions;
    private final EnumSet<IpcTagKey> optionalDimensions;
    private static final Class<?>[] METER_TYPES;
    private static final SortedSet<String> ATTEMPT_FINAL_VALUES;

    private IpcMetric(String metricName, EnumSet<IpcTagKey> requiredDimensions, EnumSet<IpcTagKey> optionalDimensions) {
        this.metricName = metricName;
        this.requiredDimensions = requiredDimensions;
        this.optionalDimensions = optionalDimensions;
    }

    public String metricName() {
        return this.metricName;
    }

    public EnumSet<IpcTagKey> requiredDimensions() {
        return this.requiredDimensions;
    }

    private static void assertTrue(boolean condition, String description, Object ... args) {
        if (!condition) {
            throw new IllegalArgumentException(String.format(description, args));
        }
    }

    private static String getName(Class<?> cls) {
        for (Class<?> c : METER_TYPES) {
            if (!c.isAssignableFrom(cls)) continue;
            return c.getSimpleName();
        }
        return cls.getSimpleName();
    }

    private static boolean isPercentile(Id id) {
        String stat = Utils.getTagValue((Id)id, (String)"statistic");
        return "percentile".equals(stat);
    }

    private static void validateIpcMeter(Registry registry, IpcMetric metric, Class<?> type, boolean strict) {
        String name = metric.metricName();
        registry.stream().filter(m -> name.equals(m.id().name()) && !IpcMetric.isPercentile(m.id())).forEach(m -> {
            IpcMetric.assertTrue(type.isAssignableFrom(m.getClass()), "[%s] has the wrong type, expected %s but found %s", m.id(), type.getSimpleName(), IpcMetric.getName(m.getClass()));
            metric.validate(m.id(), strict);
        });
    }

    public static void validate(Registry registry) {
        IpcMetric.validate(registry, false);
    }

    public static void validate(Registry registry, boolean strict) {
        IpcMetric.validateIpcMeter(registry, clientCall, Timer.class, strict);
        IpcMetric.validateIpcMeter(registry, serverCall, Timer.class, strict);
        IpcMetric.validateIpcMeter(registry, clientInflight, DistributionSummary.class, strict);
        IpcMetric.validateIpcMeter(registry, serverInflight, DistributionSummary.class, strict);
    }

    private <T extends Enum<T>> void validateValues(Id id, String key, Class<T> cls) {
        String value = Utils.getTagValue((Id)id, (String)key);
        if (value != null) {
            try {
                Enum.valueOf(cls, value);
            }
            catch (Exception e) {
                String values = Arrays.stream(cls.getEnumConstants()).map(Enum::name).collect(Collectors.joining(", "));
                throw new IllegalArgumentException(String.format("[%s] invalid value for dimension %s, acceptable values are (%s)", id, key, values));
            }
        }
    }

    private void validateValues(Id id, String key, SortedSet<String> allowedValues) {
        String value = Utils.getTagValue((Id)id, (String)key);
        if (value != null && !allowedValues.contains(value)) {
            String values = allowedValues.stream().collect(Collectors.joining(", "));
            throw new IllegalArgumentException(String.format("[%s] invalid value for dimension %s, acceptable values are (%s)", id, key, values));
        }
    }

    public void validate(Id id) {
        this.validate(id, false);
    }

    public void validate(Id id, boolean strict) {
        IpcMetric.assertTrue(this.metricName.equals(id.name()), "%s != %s", this.metricName, id.name());
        Object dimensions = this.requiredDimensions.clone();
        dimensions.forEach(k -> {
            String value = Utils.getTagValue((Id)id, (String)k.key());
            IpcMetric.assertTrue(value != null, "[%s] is missing required dimension %s", id, k.key());
        });
        this.validateValues(id, IpcTagKey.attemptFinal.key(), ATTEMPT_FINAL_VALUES);
        this.validateValues(id, IpcTagKey.attempt.key(), IpcAttempt.class);
        this.validateValues(id, IpcTagKey.result.key(), IpcResult.class);
        this.validateValues(id, IpcTagKey.status.key(), IpcStatus.class);
        this.validateValues(id, IpcTagKey.failureInjected.key(), IpcFailureInjection.class);
        String status = Utils.getTagValue((Id)id, (String)IpcTagKey.status.key());
        if (status != null) {
            IpcResult expected = IpcStatus.valueOf(status).result();
            IpcResult actual = IpcResult.valueOf(Utils.getTagValue((Id)id, (String)IpcTagKey.result.key()));
            IpcMetric.assertTrue(actual == expected, "[%s] result is inconsistent with status", id);
        }
        if (strict) {
            HashSet<String> allowedDimensions = new HashSet<String>();
            allowedDimensions.add("statistic");
            allowedDimensions.add("percentile");
            this.requiredDimensions.forEach(d -> allowedDimensions.add(d.key()));
            this.optionalDimensions.forEach(d -> allowedDimensions.add(d.key()));
            for (Tag tag : id.tags()) {
                IpcMetric.assertTrue(allowedDimensions.contains(tag.key()), "[%s] has unspecified dimension %s", id, tag.key());
            }
        }
    }

    static {
        METER_TYPES = new Class[]{Counter.class, Timer.class, DistributionSummary.class, Gauge.class};
        ATTEMPT_FINAL_VALUES = new TreeSet<String>();
        ATTEMPT_FINAL_VALUES.add(Boolean.TRUE.toString());
        ATTEMPT_FINAL_VALUES.add(Boolean.FALSE.toString());
    }
}

