/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.ipc.http;

import com.netflix.spectator.api.Registry;
import com.netflix.spectator.ipc.IpcLogger;
import com.netflix.spectator.ipc.http.Defaults;
import com.netflix.spectator.ipc.http.HttpRequestBuilder;
import java.net.URI;

@FunctionalInterface
public interface HttpClient {
    public static final IpcLogger DEFAULT_LOGGER = Defaults.IPC_LOGGER;
    public static final HttpClient DEFAULT_CLIENT = HttpClient.create(DEFAULT_LOGGER);

    public static HttpClient create(Registry registry) {
        return HttpClient.create(new IpcLogger(registry, Defaults.LOGGER));
    }

    public static HttpClient create(IpcLogger logger) {
        return uri -> new HttpRequestBuilder(logger, uri);
    }

    public HttpRequestBuilder newRequest(URI var1);

    default public HttpRequestBuilder get(URI uri) {
        return this.newRequest(uri).withMethod("GET");
    }

    default public HttpRequestBuilder post(URI uri) {
        return this.newRequest(uri).withMethod("POST");
    }

    default public HttpRequestBuilder put(URI uri) {
        return this.newRequest(uri).withMethod("PUT");
    }

    default public HttpRequestBuilder delete(URI uri) {
        return this.newRequest(uri).withMethod("DELETE");
    }
}

