/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.jvm;

import com.netflix.spectator.api.Gauge;
import com.netflix.spectator.api.Meter;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Statistic;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.api.patterns.PolledMeter;
import com.netflix.spectator.jvm.BufferPoolMeter;
import com.netflix.spectator.jvm.HotspotRuntime;
import com.netflix.spectator.jvm.JmxConfig;
import com.netflix.spectator.jvm.JmxMeter;
import com.netflix.spectator.jvm.MemoryPoolMeter;
import com.typesafe.config.Config;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.ThreadMXBean;

public final class Jmx {
    private Jmx() {
    }

    public static void registerStandardMXBeans(Registry registry) {
        Jmx.monitorClassLoadingMXBean(registry);
        Jmx.monitorThreadMXBean(registry);
        Jmx.monitorCompilationMXBean(registry);
        Jmx.maybeRegisterHotspotInternal(registry);
        for (MemoryPoolMXBean memoryPoolMXBean : ManagementFactory.getMemoryPoolMXBeans()) {
            registry.register((Meter)new MemoryPoolMeter(registry, memoryPoolMXBean));
        }
        for (BufferPoolMXBean bufferPoolMXBean : ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class)) {
            registry.register((Meter)new BufferPoolMeter(registry, bufferPoolMXBean));
        }
    }

    private static void monitorClassLoadingMXBean(Registry registry) {
        ClassLoadingMXBean classLoadingMXBean = ManagementFactory.getClassLoadingMXBean();
        ((PolledMeter.Builder)PolledMeter.using((Registry)registry).withName("jvm.classloading.classesLoaded")).monitorMonotonicCounter((Object)classLoadingMXBean, ClassLoadingMXBean::getTotalLoadedClassCount);
        ((PolledMeter.Builder)PolledMeter.using((Registry)registry).withName("jvm.classloading.classesUnloaded")).monitorMonotonicCounter((Object)classLoadingMXBean, ClassLoadingMXBean::getUnloadedClassCount);
    }

    private static void monitorThreadMXBean(Registry registry) {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        ((PolledMeter.Builder)PolledMeter.using((Registry)registry).withName("jvm.thread.threadsStarted")).monitorMonotonicCounter((Object)threadMXBean, ThreadMXBean::getTotalStartedThreadCount);
        Gauge nonDaemonThreadCount = registry.gauge("jvm.thread.threadCount", new String[]{"id", "non-daemon"});
        Gauge daemonThreadCount = registry.gauge("jvm.thread.threadCount", new String[]{"id", "daemon"});
        PolledMeter.poll((Registry)registry, () -> {
            int threads = threadMXBean.getThreadCount();
            int daemonThreads = threadMXBean.getDaemonThreadCount();
            nonDaemonThreadCount.set((double)Math.max(0, threads - daemonThreads));
            daemonThreadCount.set((double)daemonThreads);
        });
    }

    private static void monitorCompilationMXBean(Registry registry) {
        CompilationMXBean compilationMXBean = ManagementFactory.getCompilationMXBean();
        if (compilationMXBean.isCompilationTimeMonitoringSupported()) {
            ((PolledMeter.Builder)((PolledMeter.Builder)PolledMeter.using((Registry)registry).withName("jvm.compilation.compilationTime")).withTag("compiler", compilationMXBean.getName())).monitorMonotonicCounterDouble((Object)compilationMXBean, c -> (double)c.getTotalCompilationTime() / 1000.0);
        }
    }

    private static void maybeRegisterHotspotInternal(Registry registry) {
        if (HotspotRuntime.isSupported()) {
            Object mbean = HotspotRuntime.getRuntimeMBean();
            ((PolledMeter.Builder)((PolledMeter.Builder)PolledMeter.using((Registry)registry).withName("jvm.hotspot.safepointTime")).withTag((Tag)Statistic.count)).monitorMonotonicCounter(mbean, b -> HotspotRuntime.getSafepointCount());
            ((PolledMeter.Builder)((PolledMeter.Builder)PolledMeter.using((Registry)registry).withName("jvm.hotspot.safepointTime")).withTag((Tag)Statistic.totalTime)).monitorMonotonicCounterDouble(mbean, b -> (double)HotspotRuntime.getSafepointTime() / 1000.0);
            ((PolledMeter.Builder)((PolledMeter.Builder)PolledMeter.using((Registry)registry).withName("jvm.hotspot.safepointSyncTime")).withTag((Tag)Statistic.count)).monitorMonotonicCounter(mbean, b -> HotspotRuntime.getSafepointCount());
            ((PolledMeter.Builder)((PolledMeter.Builder)PolledMeter.using((Registry)registry).withName("jvm.hotspot.safepointSyncTime")).withTag((Tag)Statistic.totalTime)).monitorMonotonicCounterDouble(mbean, b -> (double)HotspotRuntime.getSafepointSyncTime() / 1000.0);
        }
    }

    public static void registerMappingsFromConfig(Registry registry, Config cfg) {
        registry.register((Meter)new JmxMeter(registry, JmxConfig.from(cfg)));
    }
}

