/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.jvm;

import com.netflix.spectator.api.AbstractMeter;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Registry;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.Collections;

class MemoryPoolMeter
extends AbstractMeter<MemoryPoolMXBean> {
    private final Id usedId;
    private final Id committedId;
    private final Id maxId;

    MemoryPoolMeter(Registry registry, MemoryPoolMXBean mbean) {
        super(registry.clock(), registry.createId("jvm.memory").withTag("id", mbean.getName()), (Object)mbean);
        this.usedId = registry.createId("jvm.memory.used").withTag("id", mbean.getName());
        this.committedId = registry.createId("jvm.memory.committed").withTag("id", mbean.getName());
        this.maxId = registry.createId("jvm.memory.max").withTag("id", mbean.getName());
    }

    public Iterable<Measurement> measure() {
        MemoryPoolMXBean mbean = (MemoryPoolMXBean)this.ref.get();
        if (mbean == null) {
            return Collections.emptyList();
        }
        long timestamp = this.clock.wallTime();
        ArrayList<Measurement> ms = new ArrayList<Measurement>(3);
        String typeKey = "memtype";
        String type = mbean.getType().name();
        MemoryUsage usage = mbean.getUsage();
        ms.add(new Measurement(this.usedId.withTag("memtype", type), timestamp, (double)usage.getUsed()));
        ms.add(new Measurement(this.committedId.withTag("memtype", type), timestamp, (double)usage.getCommitted()));
        ms.add(new Measurement(this.maxId.withTag("memtype", type), timestamp, (double)usage.getMax()));
        return ms;
    }
}

