/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.sandbox;

import com.netflix.spectator.sandbox.HttpRequestBuilder;
import com.netflix.spectator.sandbox.HttpUtils;
import java.net.URI;

public interface HttpClient {
    public static final HttpClient DEFAULT = HttpRequestBuilder::new;

    public HttpRequestBuilder newRequest(String var1, URI var2);

    default public HttpRequestBuilder get(URI uri) {
        return this.newRequest(HttpUtils.clientNameForURI(uri), uri).withMethod("GET");
    }

    default public HttpRequestBuilder post(URI uri) {
        return this.newRequest(HttpUtils.clientNameForURI(uri), uri).withMethod("POST");
    }

    default public HttpRequestBuilder put(URI uri) {
        return this.newRequest(HttpUtils.clientNameForURI(uri), uri).withMethod("PUT");
    }

    default public HttpRequestBuilder delete(URI uri) {
        return this.newRequest(HttpUtils.clientNameForURI(uri), uri).withMethod("DELETE");
    }
}

