/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.nflx;

import com.netflix.config.ConfigurationManager;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.gc.GcLogger;
import com.netflix.spectator.jvm.Jmx;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.configuration.AbstractConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
final class Plugin {
    private static final String CONFIG_FILE = "spectator.properties";
    private static final String ENABLED_PROP = "spectator.nflx.enabled";
    private static final GcLogger GC_LOGGER = new GcLogger();
    private static final Logger LOGGER = LoggerFactory.getLogger(Plugin.class);

    @Inject
    Plugin(Registry registry) throws IOException {
        AbstractConfiguration config = ConfigurationManager.getConfigInstance();
        boolean enabled = config.getBoolean(ENABLED_PROP, true);
        if (enabled) {
            ConfigurationManager.loadPropertiesFromResources((String)CONFIG_FILE);
            if (config.getBoolean("spectator.gc.loggingEnabled")) {
                GC_LOGGER.start(null);
                LOGGER.info("gc logging started");
            } else {
                LOGGER.info("gc logging is not enabled");
            }
            Jmx.registerStandardMXBeans((Registry)registry);
        } else {
            LOGGER.debug("plugin not enabled, set spectator.nflx.enabled=true to enable");
        }
    }
}

