/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.nflx;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.netflix.spectator.api.ExtendedRegistry;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Spectator;
import com.netflix.spectator.nflx.Plugin;
import com.netflix.spectator.servo.ServoRegistry;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;

public final class SpectatorModule
extends AbstractModule {
    protected void configure() {
        this.bind(Plugin.class).asEagerSingleton();
        this.bind(StaticManager.class).asEagerSingleton();
    }

    @Provides
    @Singleton
    ExtendedRegistry getExtendedRegistry() {
        return Spectator.registry();
    }

    @Provides
    @Singleton
    Registry getRegistry() {
        return new ServoRegistry();
    }

    public boolean equals(Object obj) {
        return obj != null && ((Object)((Object)this)).getClass().equals(obj.getClass());
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }

    private static class StaticManager {
        private final Registry registry;

        @Inject
        StaticManager(Registry registry) {
            this.registry = registry;
            Spectator.globalRegistry().add(registry);
        }

        @PreDestroy
        void onShutdown() {
            Spectator.globalRegistry().remove(this.registry);
        }
    }
}

