/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.atlas;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Statistic;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.atlas.AtlasMeter;
import com.netflix.spectator.atlas.DsType;
import com.netflix.spectator.atlas.MeasurementConsumer;
import com.netflix.spectator.impl.StepDouble;

class AtlasCounter
extends AtlasMeter
implements Counter {
    private final StepDouble value;
    private final Id stat;

    AtlasCounter(Registry registry, Id id, Clock clock, long ttl, long step) {
        super(id, clock, ttl);
        this.value = new StepDouble(0.0, clock, step);
        this.stat = registry.createId(id.name()).withTag((Tag)Statistic.count).withTag((Tag)DsType.rate).withTags(id.tags());
    }

    @Override
    void measure(MeasurementConsumer consumer) {
        double rate = this.value.pollAsRate();
        consumer.accept(this.stat, this.value.timestamp(), rate);
    }

    public void add(double amount) {
        if (Double.isFinite(amount) && amount > 0.0) {
            this.value.getCurrent().addAndGet(amount);
            this.updateLastModTime();
        }
    }

    public double actualCount() {
        return this.value.poll();
    }
}

