/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.atlas;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.RegistryConfig;
import com.netflix.spectator.atlas.RollupPolicy;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;

public interface AtlasConfig
extends RegistryConfig {
    default public Duration step() {
        String v = this.get("atlas.step");
        return v == null ? Duration.ofMinutes(1L) : Duration.parse(v);
    }

    default public Duration meterTTL() {
        String v = this.get("atlas.meterTTL");
        return v == null ? Duration.ofMinutes(15L) : Duration.parse(v);
    }

    default public boolean enabled() {
        String v = this.get("atlas.enabled");
        return v == null || Boolean.parseBoolean(v);
    }

    default public boolean autoStart() {
        String v = this.get("atlas.autoStart");
        return v != null && Boolean.parseBoolean(v);
    }

    default public int numThreads() {
        String v = this.get("atlas.numThreads");
        return v == null ? 4 : Integer.parseInt(v);
    }

    default public String uri() {
        String v = this.get("atlas.uri");
        return v == null ? "http://localhost:7101/api/v1/publish" : v;
    }

    default public Duration lwcStep() {
        String v = this.get("atlas.lwc.step");
        return v == null ? Duration.ofSeconds(5L) : Duration.parse(v);
    }

    default public boolean lwcEnabled() {
        String v = this.get("atlas.lwc.enabled");
        return v != null && Boolean.parseBoolean(v);
    }

    default public boolean lwcIgnorePublishStep() {
        String v = this.get("atlas.lwc.ignore-publish-step");
        return v == null || Boolean.parseBoolean(v);
    }

    default public Duration configRefreshFrequency() {
        String v = this.get("atlas.configRefreshFrequency");
        return v == null ? Duration.ofSeconds(10L) : Duration.parse(v);
    }

    default public Duration configTTL() {
        return this.configRefreshFrequency().multipliedBy(15L);
    }

    default public String configUri() {
        String v = this.get("atlas.config-uri");
        return v == null ? "http://localhost:7101/lwc/api/v1/expressions/local-dev" : v;
    }

    default public String evalUri() {
        String v = this.get("atlas.eval-uri");
        return v == null ? "http://localhost:7101/lwc/api/v1/evaluate" : v;
    }

    default public Duration connectTimeout() {
        String v = this.get("atlas.connectTimeout");
        return v == null ? Duration.ofSeconds(1L) : Duration.parse(v);
    }

    default public Duration readTimeout() {
        String v = this.get("atlas.readTimeout");
        return v == null ? Duration.ofSeconds(10L) : Duration.parse(v);
    }

    default public int batchSize() {
        String v = this.get("atlas.batchSize");
        return v == null ? 10000 : Integer.parseInt(v);
    }

    default public Map<String, String> commonTags() {
        return Collections.emptyMap();
    }

    default public String validTagCharacters() {
        return "-._A-Za-z0-9~^";
    }

    @Deprecated
    default public Map<String, String> validTagValueCharacters() {
        return Collections.emptyMap();
    }

    default public Registry debugRegistry() {
        return null;
    }

    default public RollupPolicy rollupPolicy() {
        return RollupPolicy.noop(this.commonTags());
    }

    default public long initialPollingDelay(Clock clock, long stepSize) {
        long now = clock.wallTime();
        long stepBoundary = now / stepSize * stepSize;
        long offset = stepSize / 10L;
        if (offset >= 1000L) {
            long delay = now - stepBoundary;
            if (delay < offset) {
                return delay + offset;
            }
            return Math.min(delay, stepSize - offset);
        }
        long firstTime = stepBoundary + stepSize / 10L;
        return firstTime > now ? firstTime - now : firstTime + stepSize - now;
    }
}

