/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.atlas.impl;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.atlas.impl.Query;
import com.netflix.spectator.impl.Cache;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

public final class QueryIndex<T> {
    private final Registry registry;
    private volatile String key;
    private final ConcurrentHashMap<String, QueryIndex<T>> equalChecks;
    private final ConcurrentHashMap<Query.KeyQuery, QueryIndex<T>> otherChecks;
    private final Cache<String, List<QueryIndex<T>>> otherChecksCache;
    private volatile QueryIndex<T> otherKeysIdx;
    private volatile QueryIndex<T> missingKeysIdx;
    private final Set<T> matches;

    public static <V> QueryIndex<V> newInstance(Registry registry) {
        return new QueryIndex(registry, "name");
    }

    private static <V> QueryIndex<V> empty(Registry registry) {
        return new QueryIndex(registry, null);
    }

    private static int compare(String k1, String k2) {
        if ("name".equals(k1) && "name".equals(k2)) {
            return 0;
        }
        if ("name".equals(k1)) {
            return -1;
        }
        if ("name".equals(k2)) {
            return 1;
        }
        return k1.compareTo(k2);
    }

    private QueryIndex(Registry registry, String key) {
        this.registry = registry;
        this.key = key;
        this.equalChecks = new ConcurrentHashMap();
        this.otherChecks = new ConcurrentHashMap();
        this.otherChecksCache = Cache.lfu((Registry)registry, (String)"QueryIndex", (int)100, (int)1000);
        this.otherKeysIdx = null;
        this.missingKeysIdx = null;
        this.matches = ConcurrentHashMap.newKeySet();
    }

    private List<Query.KeyQuery> sort(Query query) {
        ArrayList<Query.KeyQuery> result = new ArrayList<Query.KeyQuery>();
        for (Query q : query.andList()) {
            result.add((Query.KeyQuery)q);
        }
        result.sort((q1, q2) -> QueryIndex.compare(q1.key(), q2.key()));
        return result;
    }

    public QueryIndex<T> add(Query query, T value) {
        for (Query q : query.dnfList()) {
            if (q == Query.TRUE) {
                this.matches.add(value);
                continue;
            }
            if (q == Query.FALSE) break;
            this.add(this.sort(q), 0, value);
        }
        return this;
    }

    private void add(List<Query.KeyQuery> queries, int i, T value) {
        if (i < queries.size()) {
            int j;
            Query.KeyQuery kq = queries.get(i);
            Query.CompositeKeyQuery composite = null;
            for (j = i + 1; j < queries.size(); ++j) {
                Query.KeyQuery q = queries.get(j);
                if (!kq.key().equals(q.key())) break;
                if (composite == null) {
                    composite = new Query.CompositeKeyQuery(kq);
                    kq = composite;
                }
                composite.add(q);
            }
            if (this.key == null) {
                this.key = kq.key();
            }
            if (this.key.equals(kq.key())) {
                if (kq instanceof Query.Equal) {
                    String v = ((Query.Equal)kq).value();
                    QueryIndex idx = this.equalChecks.computeIfAbsent(v, id -> QueryIndex.empty(this.registry));
                    idx.add(queries, j, value);
                } else {
                    QueryIndex idx = this.otherChecks.computeIfAbsent(kq, id -> QueryIndex.empty(this.registry));
                    idx.add(queries, j, value);
                    this.otherChecksCache.clear();
                    if (kq instanceof Query.InvertedKeyQuery) {
                        if (this.missingKeysIdx == null) {
                            this.missingKeysIdx = QueryIndex.empty(this.registry);
                        }
                        super.add(queries, j, value);
                    }
                }
            } else {
                if (this.otherKeysIdx == null) {
                    this.otherKeysIdx = QueryIndex.empty(this.registry);
                }
                super.add(queries, i, value);
            }
        } else {
            this.matches.add(value);
        }
    }

    private <K> boolean remove(ConcurrentHashMap<K, QueryIndex<T>> map, T value) {
        boolean removed = false;
        Iterator<Map.Entry<K, QueryIndex<T>>> it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<K, QueryIndex<T>> entry = it.next();
            QueryIndex<T> idx = entry.getValue();
            if (!idx.remove(value)) continue;
            removed = true;
            if (!idx.isEmpty()) continue;
            it.remove();
        }
        return removed;
    }

    private boolean removeFromOtherChecks(T value) {
        if (this.remove(this.otherChecks, value)) {
            this.otherChecksCache.clear();
            return true;
        }
        return false;
    }

    private boolean removeFromOtherKeysIdx(T value) {
        if (this.otherKeysIdx != null && this.otherKeysIdx.remove(value)) {
            if (this.otherKeysIdx.isEmpty()) {
                this.otherKeysIdx = null;
            }
            return true;
        }
        return false;
    }

    private boolean removeFromMissingKeysIdx(T value) {
        if (this.missingKeysIdx != null && this.missingKeysIdx.remove(value)) {
            if (this.missingKeysIdx.isEmpty()) {
                this.missingKeysIdx = null;
            }
            return true;
        }
        return false;
    }

    public boolean remove(T value) {
        return this.matches.remove(value) | this.remove(this.equalChecks, value) | this.removeFromOtherChecks(value) | this.removeFromOtherKeysIdx(value) | this.removeFromMissingKeysIdx(value);
    }

    public boolean isEmpty() {
        return !(!this.matches.isEmpty() || !this.equalChecks.values().stream().allMatch(QueryIndex::isEmpty) || !this.otherChecks.values().stream().allMatch(QueryIndex::isEmpty) || this.otherKeysIdx != null && !this.otherKeysIdx.isEmpty() || this.missingKeysIdx != null && !this.missingKeysIdx.isEmpty());
    }

    public List<T> findMatches(Id id) {
        ArrayList result = new ArrayList();
        this.forEachMatch(id, result::add);
        return result;
    }

    public void forEachMatch(Id id, Consumer<T> consumer) {
        this.forEachMatch(id, 0, consumer);
    }

    private void forEachMatch(Id tags, int i, Consumer<T> consumer) {
        this.matches.forEach(consumer);
        if (this.key != null) {
            boolean keyPresent = false;
            for (int j = i; j < tags.size(); ++j) {
                String k = tags.getKey(j);
                String v = tags.getValue(j);
                int cmp = QueryIndex.compare(k, this.key);
                if (cmp == 0) {
                    List otherMatches;
                    keyPresent = true;
                    QueryIndex<T> eqIdx = this.equalChecks.get(v);
                    if (eqIdx != null) {
                        super.forEachMatch(tags, i + 1, consumer);
                    }
                    if ((otherMatches = (List)this.otherChecksCache.get((Object)v)) == null) {
                        if (this.otherChecks.isEmpty()) continue;
                        ArrayList tmp = new ArrayList();
                        this.otherChecks.forEach((kq, idx) -> {
                            if (kq.matches(v)) {
                                tmp.add(idx);
                                idx.forEachMatch(tags, i + 1, consumer);
                            }
                        });
                        this.otherChecksCache.put((Object)v, tmp);
                        continue;
                    }
                    for (QueryIndex idx2 : otherMatches) {
                        idx2.forEachMatch(tags, i + 1, consumer);
                    }
                    continue;
                }
                if (cmp > 0) break;
            }
            if (this.otherKeysIdx != null) {
                super.forEachMatch(tags, i, consumer);
            }
            if (this.missingKeysIdx != null && !keyPresent) {
                super.forEachMatch(tags, i, consumer);
            }
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.buildString(builder, 0);
        return builder.toString();
    }

    private StringBuilder indent(StringBuilder builder, int n) {
        for (int i = 0; i < n * 4; ++i) {
            builder.append(' ');
        }
        return builder;
    }

    private void buildString(StringBuilder builder, int n) {
        if (this.key != null) {
            this.indent(builder, n).append("key: [").append(this.key).append("]\n");
        }
        if (!this.equalChecks.isEmpty()) {
            this.indent(builder, n).append("equal checks:\n");
            this.equalChecks.forEach((v, idx) -> {
                this.indent(builder, n).append("- [").append((String)v).append("]\n");
                idx.buildString(builder, n + 1);
            });
        }
        if (!this.otherChecks.isEmpty()) {
            this.indent(builder, n).append("other checks:\n");
            this.otherChecks.forEach((kq, idx) -> {
                this.indent(builder, n).append("- [").append(kq).append("]\n");
                idx.buildString(builder, n + 1);
            });
        }
        if (this.otherKeysIdx != null) {
            this.indent(builder, n).append("other keys:\n");
            super.buildString(builder, n + 1);
        }
        if (this.missingKeysIdx != null) {
            this.indent(builder, n).append("missing keys:\n");
            super.buildString(builder, n + 1);
        }
        if (!this.matches.isEmpty()) {
            this.indent(builder, n).append("matches:\n");
            for (T value : this.matches) {
                this.indent(builder, n).append("- [").append(value).append("]\n");
            }
        }
    }
}

