/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.atlas.shaded.spectator-atlas.json.databind.ser.impl;

import com.netflix.spectator.atlas.shaded.spectator-atlas.json.core.JsonGenerator;
import com.netflix.spectator.atlas.shaded.spectator-atlas.json.core.JsonToken;
import com.netflix.spectator.atlas.shaded.spectator-atlas.json.core.type.WritableTypeId;
import com.netflix.spectator.atlas.shaded.spectator-atlas.json.databind.JavaType;
import com.netflix.spectator.atlas.shaded.spectator-atlas.json.databind.JsonMappingException;
import com.netflix.spectator.atlas.shaded.spectator-atlas.json.databind.JsonNode;
import com.netflix.spectator.atlas.shaded.spectator-atlas.json.databind.SerializationFeature;
import com.netflix.spectator.atlas.shaded.spectator-atlas.json.databind.SerializerProvider;
import com.netflix.spectator.atlas.shaded.spectator-atlas.json.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.netflix.spectator.atlas.shaded.spectator-atlas.json.databind.jsontype.TypeSerializer;
import com.netflix.spectator.atlas.shaded.spectator-atlas.json.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.reflect.Type;

public class UnknownSerializer
extends StdSerializer<Object> {
    public UnknownSerializer() {
        super(Object.class);
    }

    public UnknownSerializer(Class<?> cls) {
        super(cls, false);
    }

    @Override
    public void serialize(Object value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (provider.isEnabled(SerializationFeature.FAIL_ON_EMPTY_BEANS)) {
            this.failForEmpty(provider, value);
        }
        gen.writeStartObject(value, 0);
        gen.writeEndObject();
    }

    @Override
    public final void serializeWithType(Object value, JsonGenerator gen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        if (provider.isEnabled(SerializationFeature.FAIL_ON_EMPTY_BEANS)) {
            this.failForEmpty(provider, value);
        }
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(gen, typeSer.typeId(value, JsonToken.START_OBJECT));
        typeSer.writeTypeSuffix(gen, typeIdDef);
    }

    @Override
    public boolean isEmpty(SerializerProvider provider, Object value) {
        return true;
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        return null;
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        visitor.expectAnyFormat(typeHint);
    }

    protected void failForEmpty(SerializerProvider prov, Object value) throws JsonMappingException {
        prov.reportBadDefinition(this.handledType(), String.format("No serializer found for class %s and no properties discovered to create BeanSerializer (to avoid exception, disable SerializationFeature.FAIL_ON_EMPTY_BEANS)", value.getClass().getName()));
    }
}

