/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.atlas.impl;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.NoopRegistry;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.atlas.impl.Consolidator;
import com.netflix.spectator.atlas.impl.DataExpr;
import com.netflix.spectator.atlas.impl.EvalPayload;
import com.netflix.spectator.atlas.impl.Query;
import com.netflix.spectator.atlas.impl.QueryIndex;
import com.netflix.spectator.atlas.impl.Subscription;
import com.netflix.spectator.atlas.impl.TagsValuePair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Evaluator {
    private static final Logger LOGGER = LoggerFactory.getLogger(Evaluator.class);
    private final Map<String, String> commonTags;
    private final Function<Id, Map<String, String>> idMapper;
    private final long step;
    private final QueryIndex<SubscriptionEntry> index;
    private final Map<Subscription, SubscriptionEntry> subscriptions;
    private final ThreadLocal<SubscriptionEntryConsumer> consumers;

    public Evaluator(Map<String, String> commonTags, Function<Id, Map<String, String>> idMapper, long step) {
        this.commonTags = commonTags;
        this.idMapper = idMapper;
        this.step = step;
        this.index = QueryIndex.newInstance((Registry)new NoopRegistry());
        this.subscriptions = new ConcurrentHashMap<Subscription, SubscriptionEntry>();
        this.consumers = new ThreadLocal();
    }

    public synchronized void sync(List<Subscription> subs) {
        HashSet<Subscription> removed = new HashSet<Subscription>(this.subscriptions.keySet());
        for (Subscription sub : subs) {
            boolean alreadyPresent = removed.remove(sub);
            if (!alreadyPresent) {
                try {
                    Query q = sub.dataExpr().query().simplify(this.commonTags);
                    LOGGER.trace("query pre-eval: original [{}], simplified [{}], common tags {}", new Object[]{sub.dataExpr().query(), q, this.commonTags});
                    int multiple = (int)(sub.getFrequency() / this.step);
                    SubscriptionEntry entry = new SubscriptionEntry(sub, multiple);
                    this.subscriptions.put(sub, entry);
                    this.index.add(q, entry);
                    LOGGER.debug("subscription added: {}", (Object)sub);
                }
                catch (Exception e) {
                    LOGGER.warn("failed to add subscription: {}", (Object)sub, (Object)e);
                }
                continue;
            }
            LOGGER.trace("subscription already present: {}", (Object)sub);
        }
        for (Subscription sub : removed) {
            SubscriptionEntry entry = this.subscriptions.remove(sub);
            this.index.remove(entry);
            LOGGER.debug("subscription removed: {}", (Object)sub);
        }
    }

    public void update(Measurement m) {
        this.index.forEachMatch(m.id(), entry -> entry.update(m));
    }

    public void update(Id id, long t, double v) {
        SubscriptionEntryConsumer consumer = this.consumers.get();
        if (consumer == null) {
            consumer = new SubscriptionEntryConsumer();
            this.consumers.set(consumer);
        }
        consumer.updateMeasurement(id, t, v);
        this.index.forEachMatch(id, consumer);
    }

    public EvalPayload eval(long timestamp) {
        ArrayList<EvalPayload.Metric> metrics = new ArrayList<EvalPayload.Metric>();
        this.subscriptions.values().forEach(subEntry -> {
            long step = ((SubscriptionEntry)subEntry).subscription.getFrequency();
            if (timestamp % step == 0L) {
                LOGGER.debug("evaluating subscription: {}: {}", (Object)timestamp, (Object)((SubscriptionEntry)subEntry).subscription);
                DataExpr expr = ((SubscriptionEntry)subEntry).subscription.dataExpr();
                DataExpr.Aggregator aggregator = expr.aggregator(expr.query().exactTags(), false);
                Iterator it = ((SubscriptionEntry)subEntry).measurements.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    Consolidator consolidator = (Consolidator)entry.getValue();
                    consolidator.update(timestamp, Double.NaN);
                    double v = consolidator.value(timestamp);
                    if (!Double.isNaN(v)) {
                        Map<String, String> tags = this.idMapper.apply((Id)entry.getKey());
                        tags.putAll(this.commonTags);
                        TagsValuePair p = new TagsValuePair(tags, v);
                        aggregator.update(p);
                        LOGGER.trace("aggregating: {}: {}", (Object)timestamp, (Object)p);
                    }
                    if (!consolidator.isEmpty()) continue;
                    it.remove();
                }
                String subId = ((SubscriptionEntry)subEntry).subscription.getId();
                for (TagsValuePair pair : aggregator.result()) {
                    LOGGER.trace("result: {}: {}", (Object)timestamp, (Object)pair);
                    metrics.add(new EvalPayload.Metric(subId, pair.tags(), pair.value()));
                }
            }
        });
        return new EvalPayload(timestamp, metrics);
    }

    public EvalPayload eval(long t, List<Measurement> ms) {
        ms.forEach(this::update);
        return this.eval(t);
    }

    int subscriptionCount() {
        return this.subscriptions.size();
    }

    private static class SubscriptionEntryConsumer
    implements Consumer<SubscriptionEntry> {
        private Id id;
        private long timestamp;
        private double value;

        private SubscriptionEntryConsumer() {
        }

        public void updateMeasurement(Id id, long timestamp, double value) {
            this.id = id;
            this.timestamp = timestamp;
            this.value = value;
        }

        @Override
        public void accept(SubscriptionEntry entry) {
            entry.update(this.id, this.timestamp, this.value);
        }
    }

    private static class SubscriptionEntry {
        private final Subscription subscription;
        private final int multiple;
        private final Map<Id, Consolidator> measurements;

        SubscriptionEntry(Subscription subscription, int multiple) {
            this.subscription = subscription;
            this.multiple = multiple;
            this.measurements = new HashMap<Id, Consolidator>();
        }

        void update(Measurement m) {
            this.update(m.id(), m.timestamp(), m.value());
        }

        void update(Id id, long t, double v) {
            Consolidator consolidator = this.measurements.get(id);
            if (consolidator == null) {
                consolidator = Consolidator.create(id, this.subscription.getFrequency(), this.multiple);
                this.measurements.put(id, consolidator);
            }
            consolidator.update(t, v);
        }
    }
}

