/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.atlas;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.atlas.DsType;
import com.netflix.spectator.impl.StepLong;
import java.util.Collections;

class AtlasCounter
implements Counter {
    private final Id id;
    private final StepLong value;
    private final Id stat;

    AtlasCounter(Id id, Clock clock, long step) {
        this.id = id;
        this.value = new StepLong(0L, clock, step);
        this.stat = id.withTag((Tag)DsType.rate);
    }

    public Id id() {
        return this.id;
    }

    public boolean hasExpired() {
        return false;
    }

    public Iterable<Measurement> measure() {
        double rate = this.value.pollAsRate();
        Measurement m = new Measurement(this.stat, this.value.timestamp(), rate);
        return Collections.singletonList(m);
    }

    public void increment() {
        this.value.getCurrent().incrementAndGet();
    }

    public void increment(long amount) {
        this.value.getCurrent().addAndGet(amount);
    }

    public long count() {
        return this.value.poll();
    }
}

