/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.atlas;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Gauge;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.atlas.DsType;
import com.netflix.spectator.impl.AtomicDouble;
import java.util.Collections;

class AtlasGauge
implements Gauge {
    private final Id id;
    private final Clock clock;
    private final AtomicDouble value;
    private final Id stat;

    AtlasGauge(Id id, Clock clock) {
        this.id = id;
        this.clock = clock;
        this.value = new AtomicDouble(0.0);
        this.stat = id.withTag((Tag)DsType.gauge);
    }

    public Id id() {
        return this.id;
    }

    public boolean hasExpired() {
        return false;
    }

    public Iterable<Measurement> measure() {
        Measurement m = new Measurement(this.stat, this.clock.wallTime(), this.value());
        return Collections.singletonList(m);
    }

    public void set(double v) {
        this.value.set(v);
    }

    public double value() {
        return this.value.get();
    }
}

