/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.atlas;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Statistic;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.api.Timer;
import com.netflix.spectator.atlas.DsType;
import com.netflix.spectator.impl.StepDouble;
import com.netflix.spectator.impl.StepLong;
import com.netflix.spectator.impl.StepValue;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

class AtlasTimer
implements Timer {
    private final Id id;
    private final Clock clock;
    private final StepLong count;
    private final StepLong total;
    private final StepDouble totalOfSquares;
    private final StepLong max;
    private final Id[] stats;

    AtlasTimer(Id id, Clock clock, long step) {
        this.id = id;
        this.clock = clock;
        this.count = new StepLong(0L, clock, step);
        this.total = new StepLong(0L, clock, step);
        this.totalOfSquares = new StepDouble(0.0, clock, step);
        this.max = new StepLong(0L, clock, step);
        this.stats = new Id[]{id.withTags(new Tag[]{DsType.rate, Statistic.count}), id.withTags(new Tag[]{DsType.rate, Statistic.totalTime}), id.withTags(new Tag[]{DsType.rate, Statistic.totalOfSquares}), id.withTags(new Tag[]{DsType.gauge, Statistic.max})};
    }

    public Id id() {
        return this.id;
    }

    public boolean hasExpired() {
        return false;
    }

    public Iterable<Measurement> measure() {
        ArrayList<Measurement> ms = new ArrayList<Measurement>(4);
        ms.add(this.newMeasurement(this.stats[0], (StepValue)this.count, 1.0));
        ms.add(this.newMeasurement(this.stats[1], (StepValue)this.total, 1.0E-9));
        ms.add(this.newMeasurement(this.stats[2], (StepValue)this.totalOfSquares, 1.0E-18));
        ms.add(this.newMaxMeasurement(this.stats[3], this.max));
        return ms;
    }

    private Measurement newMeasurement(Id mid, StepValue v, double f) {
        double rate = v.pollAsRate() * f;
        long timestamp = v.timestamp();
        return new Measurement(mid, timestamp, rate);
    }

    private Measurement newMaxMeasurement(Id mid, StepLong v) {
        double maxValue = (double)v.poll() / 1.0E9;
        long timestamp = v.timestamp();
        return new Measurement(mid, timestamp, maxValue);
    }

    public void record(long amount, TimeUnit unit) {
        this.count.getCurrent().incrementAndGet();
        if (amount > 0L) {
            long nanos = unit.toNanos(amount);
            this.total.getCurrent().addAndGet(nanos);
            this.totalOfSquares.getCurrent().addAndGet((double)nanos * (double)nanos);
            this.updateMax(this.max.getCurrent(), nanos);
        }
    }

    private void updateMax(AtomicLong maxValue, long v) {
        long p = maxValue.get();
        while (v > p && !maxValue.compareAndSet(p, v)) {
            p = maxValue.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T record(Callable<T> f) throws Exception {
        long start = this.clock.monotonicTime();
        try {
            T t = f.call();
            return t;
        }
        finally {
            this.record(this.clock.monotonicTime() - start, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void record(Runnable f) {
        long start = this.clock.monotonicTime();
        try {
            f.run();
        }
        finally {
            this.record(this.clock.monotonicTime() - start, TimeUnit.NANOSECONDS);
        }
    }

    public long count() {
        return this.count.poll();
    }

    public long totalTime() {
        return this.total.poll();
    }
}

