/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.atlas.impl;

import com.netflix.spectator.atlas.impl.DataExpr;
import com.netflix.spectator.atlas.impl.EvalPayload;
import com.netflix.spectator.atlas.impl.Subscription;
import com.netflix.spectator.atlas.impl.TagsValuePair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Evaluator {
    private static final Logger LOGGER = LoggerFactory.getLogger(Evaluator.class);
    private final Map<String, List<Subscription>> subscriptions = new ConcurrentHashMap<String, List<Subscription>>();

    public Evaluator sync(Map<String, List<Subscription>> subs) {
        Set<String> removed = this.subscriptions.keySet();
        removed.removeAll(subs.keySet());
        removed.forEach(this::removeGroupSubscriptions);
        subs.forEach(this::addGroupSubscriptions);
        return this;
    }

    public Evaluator addGroupSubscriptions(String group, List<Subscription> subs) {
        List<Subscription> oldSubs = this.subscriptions.put(group, subs);
        if (oldSubs == null) {
            LOGGER.debug("added group {} with {} subscriptions", (Object)group, (Object)subs.size());
        } else {
            LOGGER.debug("updated group {}, {} subscriptions before, {} subscriptions now", new Object[]{group, oldSubs.size(), subs.size()});
        }
        return this;
    }

    public Evaluator removeGroupSubscriptions(String group) {
        List<Subscription> oldSubs = this.subscriptions.remove(group);
        if (oldSubs != null) {
            LOGGER.debug("removed group {} with {} subscriptions", (Object)group, (Object)oldSubs.size());
        }
        return this;
    }

    public EvalPayload eval(String group, long timestamp, List<TagsValuePair> vs) {
        List subs = this.subscriptions.getOrDefault(group, Collections.emptyList());
        ArrayList<EvalPayload.Metric> metrics = new ArrayList<EvalPayload.Metric>();
        for (Subscription s : subs) {
            DataExpr expr = s.dataExpr();
            for (TagsValuePair pair : expr.eval(vs)) {
                EvalPayload.Metric m = new EvalPayload.Metric(s.getId(), pair.tags(), pair.value());
                metrics.add(m);
            }
        }
        return new EvalPayload(timestamp, metrics);
    }
}

