/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.atlas.impl;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.impl.AsciiSet;
import java.io.IOException;

public class MeasurementSerializer
extends JsonSerializer<Measurement> {
    private final AsciiSet set;

    public MeasurementSerializer(AsciiSet set) {
        this.set = set;
    }

    private String fix(String s) {
        return this.set.replaceNonMembers(s, '_');
    }

    public void serialize(Measurement value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        Id id = value.id();
        gen.writeStartObject();
        gen.writeObjectFieldStart("tags");
        gen.writeStringField("name", this.fix(id.name()));
        boolean explicitDsType = false;
        int n = id.size();
        for (int i = 1; i < n; ++i) {
            String k = this.fix(id.getKey(i));
            String v = this.fix(id.getValue(i));
            if ("name".equals(k)) continue;
            if ("atlas.dstype".equals(k)) {
                explicitDsType = true;
            }
            gen.writeStringField(k, v);
        }
        if (!explicitDsType) {
            gen.writeStringField("atlas.dstype", "gauge");
        }
        gen.writeEndObject();
        gen.writeNumberField("timestamp", value.timestamp());
        gen.writeNumberField("value", value.value());
        gen.writeEndObject();
    }
}

