/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.atlas;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.DistributionSummary;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Statistic;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.atlas.AtlasMeter;
import com.netflix.spectator.atlas.DsType;
import com.netflix.spectator.atlas.MeasurementConsumer;
import com.netflix.spectator.impl.StepDouble;
import com.netflix.spectator.impl.StepLong;
import com.netflix.spectator.impl.StepValue;
import java.util.concurrent.atomic.AtomicLong;

class AtlasDistributionSummary
extends AtlasMeter
implements DistributionSummary {
    private final StepLong count;
    private final StepLong total;
    private final StepDouble totalOfSquares;
    private final StepLong max;
    private final Id[] stats;

    AtlasDistributionSummary(Id id, Clock clock, long ttl, long step) {
        super(id, clock, ttl);
        this.count = new StepLong(0L, clock, step);
        this.total = new StepLong(0L, clock, step);
        this.totalOfSquares = new StepDouble(0.0, clock, step);
        this.max = new StepLong(0L, clock, step);
        this.stats = new Id[]{id.withTags(new Tag[]{DsType.rate, Statistic.count}), id.withTags(new Tag[]{DsType.rate, Statistic.totalAmount}), id.withTags(new Tag[]{DsType.rate, Statistic.totalOfSquares}), id.withTags(new Tag[]{DsType.gauge, Statistic.max})};
    }

    @Override
    void measure(long now, MeasurementConsumer consumer) {
        this.reportMeasurement(now, consumer, this.stats[0], (StepValue)this.count);
        this.reportMeasurement(now, consumer, this.stats[1], (StepValue)this.total);
        this.reportMeasurement(now, consumer, this.stats[2], (StepValue)this.totalOfSquares);
        this.reportMaxMeasurement(now, consumer, this.stats[3], this.max);
    }

    private void reportMeasurement(long now, MeasurementConsumer consumer, Id mid, StepValue v) {
        double rate = v.pollAsRate(now);
        long timestamp = v.timestamp();
        consumer.accept(mid, timestamp, rate);
    }

    private void reportMaxMeasurement(long now, MeasurementConsumer consumer, Id mid, StepLong v) {
        double maxValue = v.poll(now);
        long timestamp = v.timestamp();
        consumer.accept(mid, timestamp, maxValue);
    }

    public void record(long amount) {
        long now = this.clock.wallTime();
        this.count.getCurrent(now).incrementAndGet();
        if (amount > 0L) {
            this.total.getCurrent(now).addAndGet(amount);
            this.totalOfSquares.getCurrent(now).addAndGet((double)amount * (double)amount);
            this.updateMax(this.max.getCurrent(now), amount);
        }
        this.updateLastModTime(now);
    }

    public void record(long[] amounts, int n) {
        int limit = Math.min(Math.max(0, n), amounts.length);
        long accumulatedTotal = 0L;
        long accumulatedMax = Long.MIN_VALUE;
        double accumulatedTotalOfSquares = 0.0;
        for (int i = 0; i < limit; ++i) {
            if (amounts[i] <= 0L) continue;
            accumulatedTotal += amounts[i];
            accumulatedTotalOfSquares += (double)amounts[i] * (double)amounts[i];
            accumulatedMax = Math.max(amounts[i], accumulatedMax);
        }
        long now = this.clock.wallTime();
        this.count.getCurrent(now).addAndGet(limit);
        this.total.getCurrent(now).addAndGet(accumulatedTotal);
        this.totalOfSquares.getCurrent(now).addAndGet(accumulatedTotalOfSquares);
        this.updateMax(this.max.getCurrent(now), accumulatedMax);
        this.updateLastModTime(now);
    }

    private void updateMax(AtomicLong maxValue, long v) {
        long p = maxValue.get();
        while (v > p && !maxValue.compareAndSet(p, v)) {
            p = maxValue.get();
        }
    }

    public long count() {
        return this.count.poll();
    }

    public long totalAmount() {
        return this.total.poll();
    }
}

