/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.atlas;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.atlas.AtlasConfig;
import com.netflix.spectator.atlas.impl.Subscription;
import com.netflix.spectator.atlas.impl.Subscriptions;
import com.netflix.spectator.atlas.shaded.spectator-atlas.json.databind.ObjectMapper;
import com.netflix.spectator.ipc.http.HttpClient;
import com.netflix.spectator.ipc.http.HttpResponse;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SubscriptionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionManager.class);
    private final ObjectMapper mapper;
    private final HttpClient client;
    private final Clock clock;
    private final URI uri;
    private final int connectTimeout;
    private final int readTimeout;
    private final long stepMillis;
    private final long lwcStepMillis;
    private final boolean ignorePublishStep;
    private final long configTTL;
    private final Map<Subscription, Long> subscriptions = new ConcurrentHashMap<Subscription, Long>();
    private Subscriptions payload;
    private String etag;

    SubscriptionManager(ObjectMapper mapper, HttpClient client, Clock clock, AtlasConfig config) {
        this.mapper = mapper;
        this.client = client;
        this.clock = clock;
        this.uri = URI.create(config.configUri());
        this.connectTimeout = (int)config.connectTimeout().toMillis();
        this.readTimeout = (int)config.readTimeout().toMillis();
        this.stepMillis = config.step().toMillis();
        this.lwcStepMillis = config.lwcStep().toMillis();
        this.ignorePublishStep = config.lwcIgnorePublishStep();
        this.configTTL = config.configTTL().toMillis();
    }

    List<Subscription> subscriptions() {
        return new ArrayList<Subscription>(this.subscriptions.keySet());
    }

    void refresh() {
        block17: {
            try {
                HttpResponse res = this.client.get(this.uri).withConnectTimeout(this.connectTimeout).withReadTimeout(this.readTimeout).acceptGzip().addHeader("If-None-Match", this.etag).reuseResponseBuffers(true).send();
                if (res.status() == 304) {
                    LOGGER.debug("no modification to subscriptions");
                    break block17;
                }
                if (res.status() != 200) {
                    LOGGER.warn("failed to update subscriptions, received status {}", (Object)res.status());
                    break block17;
                }
                this.etag = res.header("ETag");
                try (InputStream in = res.entityInputStream();){
                    this.payload = this.filterByStep(this.mapper.readValue(in, Subscriptions.class));
                }
            }
            catch (Exception e) {
                LOGGER.warn("failed to update subscriptions (uri={})", (Object)this.uri, (Object)e);
            }
        }
        if (this.payload != null) {
            long now = this.clock.wallTime();
            this.payload.update(this.subscriptions, now, now + this.configTTL);
        }
    }

    private Subscriptions filterByStep(Subscriptions subs) {
        ArrayList<Subscription> filtered = new ArrayList<Subscription>(subs.getExpressions().size());
        for (Subscription sub : subs.getExpressions()) {
            if (this.isSupportedFrequency(sub.getFrequency())) {
                filtered.add(sub);
                continue;
            }
            LOGGER.trace("ignored subscription with invalid frequency: {}", (Object)sub);
        }
        return new Subscriptions().withExpressions(filtered);
    }

    private boolean isSupportedFrequency(long s) {
        return s >= this.lwcStepMillis && s % this.lwcStepMillis == 0L && (s != this.stepMillis || !this.ignorePublishStep);
    }
}

