/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.atlas;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.NoopRegistry;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.api.Utils;
import com.netflix.spectator.atlas.DsType;
import com.netflix.spectator.atlas.RollupPolicy;
import com.netflix.spectator.atlas.impl.Parser;
import com.netflix.spectator.atlas.impl.Query;
import com.netflix.spectator.atlas.impl.QueryIndex;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.DoubleBinaryOperator;
import java.util.function.Function;

final class Rollups {
    private static final Set<String> SUM_STATS = new LinkedHashSet<String>();
    private static final DoubleBinaryOperator SUM;
    private static final DoubleBinaryOperator MAX;

    private Rollups() {
    }

    static RollupPolicy fromRules(Map<String, String> commonTags, List<RollupPolicy.Rule> rules) {
        QueryIndex index = QueryIndex.newInstance((Registry)new NoopRegistry());
        for (RollupPolicy.Rule rule : rules) {
            Query query = Parser.parseQuery(rule.query()).simplify(commonTags);
            index.add(query, rule);
        }
        return ms -> {
            HashMap<Map, Map> aggregates = new HashMap<Map, Map>();
            for (Measurement m : ms) {
                List<RollupPolicy.Rule> matches = index.findMatches(m.id());
                if (matches.isEmpty()) {
                    Map idMap = aggregates.computeIfAbsent(commonTags, k -> new HashMap());
                    Rollups.updateAggregate(idMap, m.id(), m);
                    continue;
                }
                if (Rollups.shouldDrop(matches)) continue;
                HashSet<String> commonDimensions = new HashSet<String>();
                HashSet<String> otherDimensions = new HashSet<String>();
                for (RollupPolicy.Rule rule : matches) {
                    for (String dimension : rule.rollup()) {
                        if (commonTags.containsKey(dimension)) {
                            commonDimensions.add(dimension);
                            continue;
                        }
                        otherDimensions.add(dimension);
                    }
                }
                Map<String, String> tags = commonDimensions.isEmpty() ? commonTags : Rollups.rollup(commonTags, commonDimensions);
                Id id = otherDimensions.isEmpty() ? m.id() : m.id().filterByKey(k -> !otherDimensions.contains(k));
                Map idMap = aggregates.computeIfAbsent(tags, k -> new HashMap());
                Rollups.updateAggregate(idMap, id, m);
            }
            ArrayList<RollupPolicy.Result> results = new ArrayList<RollupPolicy.Result>();
            for (Map.Entry entry : aggregates.entrySet()) {
                results.add(new RollupPolicy.Result((Map)entry.getKey(), Rollups.toMeasurements((Map)entry.getValue())));
            }
            return results;
        };
    }

    private static boolean shouldDrop(List<RollupPolicy.Rule> rules) {
        for (RollupPolicy.Rule rule : rules) {
            if (rule.operation() != RollupPolicy.Operation.DROP) continue;
            return true;
        }
        return false;
    }

    private static Map<String, String> rollup(Map<String, String> tags, Set<String> dimensions) {
        HashMap<String, String> tmp = new HashMap<String, String>(tags);
        for (String dimension : dimensions) {
            tmp.remove(dimension);
        }
        return tmp;
    }

    static List<Measurement> aggregate(Function<Id, Id> idMapper, List<Measurement> measurements) {
        HashMap<Id, Aggregator> aggregates = new HashMap<Id, Aggregator>();
        for (Measurement m : measurements) {
            Id id = idMapper.apply(m.id());
            if (id == null) continue;
            Rollups.updateAggregate(aggregates, id, m);
        }
        return Rollups.toMeasurements(aggregates);
    }

    private static void updateAggregate(Map<Id, Aggregator> aggregates, Id id, Measurement m) {
        Aggregator aggregator = aggregates.get(id);
        if (aggregator == null) {
            aggregator = Rollups.newAggregator(id, m);
            aggregates.put(id, aggregator);
        } else {
            aggregator.update(m);
        }
    }

    private static List<Measurement> toMeasurements(Map<Id, Aggregator> aggregates) {
        ArrayList<Measurement> result = new ArrayList<Measurement>(aggregates.size());
        for (Aggregator aggregator : aggregates.values()) {
            result.add(aggregator.toMeasurement());
        }
        return result;
    }

    private static DoubleBinaryOperator nanAwareOp(DoubleBinaryOperator op) {
        return (a, b) -> Double.isNaN(a) ? b : (Double.isNaN(b) ? a : op.applyAsDouble(a, b));
    }

    private static Aggregator newAggregator(Id id, Measurement m) {
        String statistic = Utils.getTagValue((Id)id, (String)"statistic");
        if (statistic != null && SUM_STATS.contains(statistic)) {
            return new Aggregator(id.withTag((Tag)DsType.sum), m.timestamp(), SUM, m.value());
        }
        return new Aggregator(id, m.timestamp(), MAX, m.value());
    }

    static {
        SUM_STATS.add("count");
        SUM_STATS.add("totalAmount");
        SUM_STATS.add("totalTime");
        SUM_STATS.add("totalOfSquares");
        SUM_STATS.add("percentile");
        SUM = Rollups.nanAwareOp(Double::sum);
        MAX = Rollups.nanAwareOp(Double::max);
    }

    private static class Aggregator {
        private final Id id;
        private final long timestamp;
        private final DoubleBinaryOperator af;
        private double value;

        Aggregator(Id id, long timestamp, DoubleBinaryOperator af, double init) {
            this.id = id;
            this.timestamp = timestamp;
            this.af = af;
            this.value = init;
        }

        void update(Measurement m) {
            this.value = this.af.applyAsDouble(this.value, m.value());
        }

        Measurement toMeasurement() {
            return new Measurement(this.id, this.timestamp, this.value);
        }
    }
}

