/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.atlas.impl;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.atlas.impl.PrefixTree;
import com.netflix.spectator.atlas.impl.Query;
import com.netflix.spectator.impl.Cache;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public final class QueryIndex<T> {
    private final CacheSupplier<T> cacheSupplier;
    private volatile String key;
    private final ConcurrentHashMap<String, QueryIndex<T>> equalChecks;
    private final ConcurrentHashMap<Query.KeyQuery, QueryIndex<T>> otherChecks;
    private final PrefixTree<Query.KeyQuery> otherChecksTree;
    private final Cache<String, List<QueryIndex<T>>> otherChecksCache;
    private volatile QueryIndex<T> hasKeyIdx;
    private volatile QueryIndex<T> otherKeysIdx;
    private volatile QueryIndex<T> missingKeysIdx;
    private final Set<T> matches;

    public static <V> QueryIndex<V> newInstance(Registry registry) {
        return QueryIndex.newInstance(new DefaultCacheSupplier(registry));
    }

    public static <V> QueryIndex<V> newInstance(CacheSupplier<V> cacheSupplier) {
        return new QueryIndex<V>(cacheSupplier, "name");
    }

    private static <V> QueryIndex<V> empty(CacheSupplier<V> cacheSupplier) {
        return new QueryIndex<V>(cacheSupplier, null);
    }

    private static int compare(String k1, String k2) {
        if ("name".equals(k1) && "name".equals(k2)) {
            return 0;
        }
        if ("name".equals(k1)) {
            return -1;
        }
        if ("name".equals(k2)) {
            return 1;
        }
        return k1.compareTo(k2);
    }

    private QueryIndex(CacheSupplier<T> cacheSupplier, String key) {
        this.cacheSupplier = cacheSupplier;
        this.key = key;
        this.equalChecks = new ConcurrentHashMap();
        this.otherChecks = new ConcurrentHashMap();
        this.otherChecksTree = new PrefixTree();
        this.otherChecksCache = (Cache)cacheSupplier.get();
        this.hasKeyIdx = null;
        this.otherKeysIdx = null;
        this.missingKeysIdx = null;
        this.matches = new CopyOnWriteArraySet<T>();
    }

    private List<Query.KeyQuery> sort(Query query) {
        ArrayList<Query.KeyQuery> result = new ArrayList<Query.KeyQuery>();
        for (Query q : query.andList()) {
            result.add((Query.KeyQuery)q);
        }
        result.sort((q1, q2) -> QueryIndex.compare(q1.key(), q2.key()));
        return result;
    }

    public QueryIndex<T> add(Query query, T value) {
        for (Query q : query.dnfList()) {
            if (q == Query.TRUE) {
                this.matches.add(value);
                continue;
            }
            if (q == Query.FALSE) break;
            this.add(this.sort(q), 0, value);
        }
        return this;
    }

    private void add(List<Query.KeyQuery> queries, int i, T value) {
        if (i < queries.size()) {
            int j;
            Query.KeyQuery kq = queries.get(i);
            Query.CompositeKeyQuery composite = null;
            for (j = i + 1; j < queries.size(); ++j) {
                Query.KeyQuery q = queries.get(j);
                if (!kq.key().equals(q.key())) break;
                if (composite == null) {
                    composite = new Query.CompositeKeyQuery(kq);
                    kq = composite;
                }
                composite.add(q);
            }
            if (this.key == null) {
                this.key = kq.key();
            }
            if (this.key.equals(kq.key())) {
                if (kq instanceof Query.Equal) {
                    String v = ((Query.Equal)kq).value();
                    QueryIndex idx = this.equalChecks.computeIfAbsent(v, id -> QueryIndex.empty(this.cacheSupplier));
                    idx.add(queries, j, value);
                } else if (kq instanceof Query.Has) {
                    if (this.hasKeyIdx == null) {
                        this.hasKeyIdx = QueryIndex.empty(this.cacheSupplier);
                    }
                    super.add(queries, j, value);
                } else {
                    QueryIndex idx = this.otherChecks.computeIfAbsent(kq, id -> QueryIndex.empty(this.cacheSupplier));
                    idx.add(queries, j, value);
                    if (kq instanceof Query.Regex) {
                        Query.Regex re = (Query.Regex)kq;
                        this.otherChecksTree.put(re.pattern().prefix(), kq);
                    } else {
                        this.otherChecksTree.put(null, kq);
                    }
                    this.otherChecksCache.clear();
                    if (kq.matches(Collections.emptyMap())) {
                        if (this.missingKeysIdx == null) {
                            this.missingKeysIdx = QueryIndex.empty(this.cacheSupplier);
                        }
                        super.add(queries, j, value);
                    }
                }
            } else {
                if (this.otherKeysIdx == null) {
                    this.otherKeysIdx = QueryIndex.empty(this.cacheSupplier);
                }
                super.add(queries, i, value);
            }
        } else {
            this.matches.add(value);
        }
    }

    public boolean remove(Query query, T value) {
        boolean result = false;
        for (Query q : query.dnfList()) {
            if (q == Query.TRUE) {
                result |= this.matches.remove(value);
                continue;
            }
            if (q == Query.FALSE) break;
            result |= this.remove(this.sort(q), 0, value);
        }
        return result;
    }

    private boolean remove(List<Query.KeyQuery> queries, int i, T value) {
        boolean result = false;
        if (i < queries.size()) {
            int j;
            Query.KeyQuery kq = queries.get(i);
            Query.CompositeKeyQuery composite = null;
            for (j = i + 1; j < queries.size(); ++j) {
                Query.KeyQuery q = queries.get(j);
                if (!kq.key().equals(q.key())) break;
                if (composite == null) {
                    composite = new Query.CompositeKeyQuery(kq);
                    kq = composite;
                }
                composite.add(q);
            }
            if (this.key != null && this.key.equals(kq.key())) {
                if (kq instanceof Query.Equal) {
                    String v = ((Query.Equal)kq).value();
                    QueryIndex<T> idx = this.equalChecks.get(v);
                    if (idx != null) {
                        result |= super.remove(queries, j, value);
                        if (idx.isEmpty()) {
                            this.equalChecks.remove(v);
                        }
                    }
                } else if (kq instanceof Query.Has) {
                    if (this.hasKeyIdx != null) {
                        result |= super.remove(queries, j, value);
                        if (this.hasKeyIdx.isEmpty()) {
                            this.hasKeyIdx = null;
                        }
                    }
                } else {
                    QueryIndex<T> idx = this.otherChecks.get(kq);
                    if (idx != null && super.remove(queries, j, value)) {
                        result = true;
                        this.otherChecksCache.clear();
                        if (idx.isEmpty()) {
                            this.otherChecks.remove(kq);
                            if (kq instanceof Query.Regex) {
                                Query.Regex re = (Query.Regex)kq;
                                this.otherChecksTree.remove(re.pattern().prefix(), kq);
                            } else {
                                this.otherChecksTree.remove(null, kq);
                            }
                        }
                    }
                    if (kq.matches(Collections.emptyMap()) && this.missingKeysIdx != null) {
                        result |= super.remove(queries, j, value);
                        if (this.missingKeysIdx.isEmpty()) {
                            this.missingKeysIdx = null;
                        }
                    }
                }
            } else if (this.otherKeysIdx != null) {
                result |= super.remove(queries, i, value);
                if (this.otherKeysIdx.isEmpty()) {
                    this.otherKeysIdx = null;
                }
            }
        } else {
            result |= this.matches.remove(value);
        }
        return result;
    }

    public boolean isEmpty() {
        return !(!this.matches.isEmpty() || !this.equalChecks.values().stream().allMatch(QueryIndex::isEmpty) || !this.otherChecks.values().stream().allMatch(QueryIndex::isEmpty) || this.hasKeyIdx != null && !this.hasKeyIdx.isEmpty() || this.otherKeysIdx != null && !this.otherKeysIdx.isEmpty() || this.missingKeysIdx != null && !this.missingKeysIdx.isEmpty());
    }

    public List<T> findMatches(Id id) {
        ArrayList result = new ArrayList();
        this.forEachMatch(id, result::add);
        return result;
    }

    public void forEachMatch(Id id, Consumer<T> consumer) {
        this.forEachMatch(id, 0, consumer);
    }

    private void forEachMatch(Id tags, int i, Consumer<T> consumer) {
        this.matches.forEach(consumer);
        if (this.key != null) {
            boolean keyPresent = false;
            for (int j = i; j < tags.size(); ++j) {
                String k = tags.getKey(j);
                String v = tags.getValue(j);
                int cmp = QueryIndex.compare(k, this.key);
                if (cmp == 0) {
                    List otherMatches;
                    keyPresent = true;
                    QueryIndex<T> eqIdx = this.equalChecks.get(v);
                    if (eqIdx != null) {
                        super.forEachMatch(tags, i + 1, consumer);
                    }
                    if ((otherMatches = (List)this.otherChecksCache.get((Object)v)) == null) {
                        if (!this.otherChecks.isEmpty()) {
                            ArrayList tmp = new ArrayList();
                            this.otherChecksTree.forEach(v, kq -> {
                                QueryIndex<T> idx;
                                if (kq.matches(v) && (idx = this.otherChecks.get(kq)) != null) {
                                    tmp.add(idx);
                                    super.forEachMatch(tags, i + 1, consumer);
                                }
                            });
                            this.otherChecksCache.put((Object)v, tmp);
                        }
                    } else {
                        int n = otherMatches.size();
                        for (int p = 0; p < n; ++p) {
                            ((QueryIndex)otherMatches.get(p)).forEachMatch(tags, i + 1, consumer);
                        }
                    }
                    if (this.hasKeyIdx != null) {
                        super.forEachMatch(tags, i, consumer);
                    }
                }
                if (cmp >= 0) break;
            }
            if (this.otherKeysIdx != null) {
                super.forEachMatch(tags, i, consumer);
            }
            if (this.missingKeysIdx != null && !keyPresent) {
                super.forEachMatch(tags, i, consumer);
            }
        }
    }

    public List<T> findMatches(Function<String, String> tags) {
        ArrayList result = new ArrayList();
        this.forEachMatch(tags, result::add);
        return result;
    }

    public void forEachMatch(Function<String, String> tags, Consumer<T> consumer) {
        String v;
        this.matches.forEach(consumer);
        boolean keyPresent = false;
        if (this.key != null && (v = tags.apply(this.key)) != null) {
            List otherMatches;
            keyPresent = true;
            QueryIndex<T> eqIdx = this.equalChecks.get(v);
            if (eqIdx != null) {
                eqIdx.forEachMatch(tags, consumer);
            }
            if ((otherMatches = (List)this.otherChecksCache.get((Object)v)) == null) {
                if (!this.otherChecks.isEmpty()) {
                    ArrayList tmp = new ArrayList();
                    this.otherChecksTree.forEach(v, kq -> {
                        QueryIndex<T> idx;
                        if (this.matches((Query.KeyQuery)kq, v) && (idx = this.otherChecks.get(kq)) != null) {
                            tmp.add(idx);
                            idx.forEachMatch(tags, consumer);
                        }
                    });
                    this.otherChecksCache.put((Object)v, tmp);
                }
            } else {
                int n = otherMatches.size();
                for (int p = 0; p < n; ++p) {
                    ((QueryIndex)otherMatches.get(p)).forEachMatch(tags, consumer);
                }
            }
            if (this.hasKeyIdx != null) {
                this.hasKeyIdx.forEachMatch(tags, consumer);
            }
        }
        if (this.otherKeysIdx != null) {
            this.otherKeysIdx.forEachMatch(tags, consumer);
        }
        if (this.missingKeysIdx != null && !keyPresent) {
            this.missingKeysIdx.forEachMatch(tags, consumer);
        }
    }

    private boolean matches(Query.KeyQuery kq, String value) {
        if (kq instanceof Query.Regex) {
            Query.Regex re = (Query.Regex)kq;
            return re.pattern().matchesAfterPrefix(value);
        }
        return kq.matches(value);
    }

    public void findHotSpots(int threshold, BiConsumer<List<String>, List<Query.KeyQuery>> consumer) {
        ArrayDeque<String> path = new ArrayDeque<String>();
        this.findHotSpots(threshold, path, consumer);
    }

    private void findHotSpots(int threshold, Deque<String> path, BiConsumer<List<String>, List<Query.KeyQuery>> consumer) {
        if (this.key != null) {
            path.addLast("K=" + this.key);
            this.equalChecks.forEach((v, idx) -> {
                path.addLast(this.key + "," + v + ",:eq");
                idx.findHotSpots(threshold, path, consumer);
                path.removeLast();
            });
            path.addLast("other-checks");
            if (this.otherChecks.size() > threshold) {
                ArrayList queries = new ArrayList(this.otherChecks.keySet());
                consumer.accept(new ArrayList<String>(path), queries);
            }
            this.otherChecks.forEach((q, idx) -> {
                path.addLast(q.toString());
                idx.findHotSpots(threshold, path, consumer);
                path.removeLast();
            });
            path.removeLast();
            if (this.hasKeyIdx != null) {
                path.addLast("has");
                super.findHotSpots(threshold, path, consumer);
                path.removeLast();
            }
            path.removeLast();
        }
        if (this.otherKeysIdx != null) {
            path.addLast("other-keys");
            super.findHotSpots(threshold, path, consumer);
            path.removeLast();
        }
        if (this.missingKeysIdx != null) {
            path.addLast("missing-keys");
            super.findHotSpots(threshold, path, consumer);
            path.removeLast();
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.buildString(builder, 0);
        return builder.toString();
    }

    private StringBuilder indent(StringBuilder builder, int n) {
        for (int i = 0; i < n * 4; ++i) {
            builder.append(' ');
        }
        return builder;
    }

    private void buildString(StringBuilder builder, int n) {
        if (this.key != null) {
            this.indent(builder, n).append("key: [").append(this.key).append("]\n");
        }
        if (!this.equalChecks.isEmpty()) {
            this.indent(builder, n).append("equal checks:\n");
            this.equalChecks.forEach((v, idx) -> {
                this.indent(builder, n).append("- [").append((String)v).append("]\n");
                idx.buildString(builder, n + 1);
            });
        }
        if (!this.otherChecks.isEmpty()) {
            this.indent(builder, n).append("other checks:\n");
            this.otherChecks.forEach((kq, idx) -> {
                this.indent(builder, n).append("- [").append(kq).append("]\n");
                idx.buildString(builder, n + 1);
            });
        }
        if (this.hasKeyIdx != null) {
            this.indent(builder, n).append("has key:\n");
            super.buildString(builder, n + 1);
        }
        if (this.otherKeysIdx != null) {
            this.indent(builder, n).append("other keys:\n");
            super.buildString(builder, n + 1);
        }
        if (this.missingKeysIdx != null) {
            this.indent(builder, n).append("missing keys:\n");
            super.buildString(builder, n + 1);
        }
        if (!this.matches.isEmpty()) {
            this.indent(builder, n).append("matches:\n");
            for (T value : this.matches) {
                this.indent(builder, n).append("- [").append(value).append("]\n");
            }
        }
    }

    public static class DefaultCacheSupplier<V>
    implements CacheSupplier<V> {
        private final Registry registry;

        DefaultCacheSupplier(Registry registry) {
            this.registry = registry;
        }

        @Override
        public Cache<String, List<QueryIndex<V>>> get() {
            return Cache.lfu((Registry)this.registry, (String)"QueryIndex", (int)100, (int)1000);
        }
    }

    public static interface CacheSupplier<V>
    extends Supplier<Cache<String, List<QueryIndex<V>>>> {
    }
}

