/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.atlas.impl;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Utils;
import com.netflix.spectator.atlas.impl.Consolidator;
import com.netflix.spectator.atlas.impl.DataExpr;
import com.netflix.spectator.atlas.impl.EvalPayload;
import com.netflix.spectator.atlas.impl.EvaluatorConfig;
import com.netflix.spectator.atlas.impl.Query;
import com.netflix.spectator.atlas.impl.QueryIndex;
import com.netflix.spectator.atlas.impl.Subscription;
import com.netflix.spectator.atlas.impl.TagsValuePair;
import com.netflix.spectator.impl.Hash64;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Evaluator {
    private static final Logger LOGGER = LoggerFactory.getLogger(Evaluator.class);
    private final Lock lock = new ReentrantLock();
    private final Map<String, String> commonTags;
    private final BiFunction<Id, Set<String>, Map<String, String>> idMapper;
    private final long step;
    private final boolean delayGaugeAggregation;
    private final QueryIndex<SubscriptionEntry> index;
    private final Map<Subscription, SubscriptionEntry> subscriptions;
    private final ThreadLocal<SubscriptionEntryConsumer> consumers;

    public Evaluator(EvaluatorConfig config) {
        this.commonTags = new TreeMap<String, String>(config.commonTags());
        this.idMapper = config.idMapper();
        this.step = config.evaluatorStepSize();
        this.delayGaugeAggregation = config.delayGaugeAggregation();
        this.index = QueryIndex.newInstance(config.indexCacheSupplier());
        this.subscriptions = new ConcurrentHashMap<Subscription, SubscriptionEntry>();
        this.consumers = new ThreadLocal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync(List<Subscription> subs) {
        this.lock.lock();
        try {
            Query q;
            HashSet<Subscription> removed = new HashSet<Subscription>(this.subscriptions.keySet());
            for (Subscription sub : subs) {
                boolean alreadyPresent = removed.remove(sub);
                if (!alreadyPresent) {
                    try {
                        q = sub.dataExpr().query().simplify(this.commonTags);
                        LOGGER.trace("query pre-eval: original [{}], simplified [{}], common tags {}", new Object[]{sub.dataExpr().query(), q, this.commonTags});
                        int multiple = (int)(sub.getFrequency() / this.step);
                        SubscriptionEntry entry = new SubscriptionEntry(sub, multiple);
                        this.subscriptions.put(sub, entry);
                        this.index.add(q, entry);
                        LOGGER.debug("subscription added: {}", (Object)sub);
                    }
                    catch (Exception e) {
                        LOGGER.warn("failed to add subscription: {}", (Object)sub, (Object)e);
                    }
                    continue;
                }
                LOGGER.trace("subscription already present: {}", (Object)sub);
            }
            for (Subscription sub : removed) {
                SubscriptionEntry entry = this.subscriptions.remove(sub);
                q = sub.dataExpr().query().simplify(this.commonTags);
                this.index.remove(q, entry);
                LOGGER.debug("subscription removed: {}", (Object)sub);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void update(Measurement m) {
        this.index.forEachMatch(m.id(), entry -> entry.update(m));
    }

    public void update(Id id, long t, double v) {
        SubscriptionEntryConsumer consumer = this.consumers.get();
        if (consumer == null) {
            consumer = new SubscriptionEntryConsumer();
            this.consumers.set(consumer);
        }
        consumer.updateMeasurement(id, t, v);
        this.index.forEachMatch(id, (Consumer<SubscriptionEntry>)consumer);
    }

    public EvalPayload eval(long timestamp) {
        return this.eval(timestamp, false);
    }

    public EvalPayload eval(long timestamp, boolean parallel) {
        ConcurrentLinkedQueue metrics = new ConcurrentLinkedQueue();
        StreamSupport.stream(this.subscriptions.values().spliterator(), parallel).forEach(subEntry -> {
            String subId = ((SubscriptionEntry)subEntry).subscription.getId();
            long step = ((SubscriptionEntry)subEntry).subscription.getFrequency();
            if (timestamp % step == 0L) {
                LOGGER.debug("evaluating subscription: {}: {}", (Object)timestamp, (Object)((SubscriptionEntry)subEntry).subscription);
                DataExpr expr = ((SubscriptionEntry)subEntry).subscription.dataExpr();
                boolean delayGaugeAggr = this.delayGaugeAggregation && expr.isAccumulating();
                DataExpr.Aggregator aggregator = expr.aggregator(false);
                Iterator it = ((SubscriptionEntry)subEntry).measurements.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    Consolidator consolidator = (Consolidator)entry.getValue();
                    consolidator.update(timestamp, Double.NaN);
                    double v = consolidator.value(timestamp);
                    if (!Double.isNaN(v)) {
                        Map<String, String> tags = null;
                        if (expr instanceof DataExpr.GroupBy) {
                            DataExpr.GroupBy by = (DataExpr.GroupBy)expr;
                            Set<String> keys = by.keys();
                            tags = this.idMapper.apply((Id)entry.getKey(), keys);
                            this.putCommonTags(tags, keys);
                            if (tags.size() < keys.size()) {
                                tags = null;
                            } else {
                                tags.putAll(by.aggregateFunction().queryTags());
                            }
                        } else if (expr instanceof DataExpr.AggregateFunction) {
                            DataExpr.AggregateFunction af = (DataExpr.AggregateFunction)expr;
                            tags = new HashMap<String, String>(af.resultTags(af.queryTags()));
                        }
                        if (delayGaugeAggr && consolidator.isGauge()) {
                            if (tags != null) {
                                tags.put("atlas.aggr", this.idHash((Id)entry.getKey()));
                                double acc = expr.isCount() ? 1.0 : v;
                                metrics.add(new EvalPayload.Metric(subId, tags, acc));
                            }
                        } else if (tags != null) {
                            TagsValuePair p = new TagsValuePair(tags, v);
                            aggregator.update(p);
                            LOGGER.trace("aggregating: {}: {}", (Object)timestamp, (Object)p);
                        }
                    }
                    if (!consolidator.isEmpty()) continue;
                    it.remove();
                }
                for (TagsValuePair pair : aggregator.result()) {
                    LOGGER.trace("result: {}: {}", (Object)timestamp, (Object)pair);
                    metrics.add(new EvalPayload.Metric(subId, pair.tags(), pair.value()));
                }
            }
        });
        return new EvalPayload(timestamp, new ArrayList<EvalPayload.Metric>(metrics));
    }

    private void putCommonTags(Map<String, String> dst, Set<String> keys) {
        if (dst.size() < keys.size()) {
            for (String key : keys) {
                String value = this.commonTags.get(key);
                if (value == null) continue;
                dst.put(key, value);
            }
        }
    }

    private String idHash(Id id) {
        Hash64 hasher = new Hash64();
        hasher.updateString((CharSequence)id.name());
        int size = id.size();
        for (int i = 1; i < size; ++i) {
            hasher.updateByte((byte)44);
            hasher.updateString((CharSequence)id.getKey(i));
            hasher.updateByte((byte)61);
            hasher.updateString((CharSequence)id.getValue(i));
        }
        return Long.toHexString(hasher.compute());
    }

    public EvalPayload eval(long t, List<Measurement> ms) {
        ms.forEach(this::update);
        return this.eval(t);
    }

    int subscriptionCount() {
        return this.subscriptions.size();
    }

    private static final class SubscriptionEntryConsumer
    implements Consumer<SubscriptionEntry> {
        private Id id;
        private long timestamp;
        private double value;

        private SubscriptionEntryConsumer() {
        }

        public void updateMeasurement(Id id, long timestamp, double value) {
            this.id = id;
            this.timestamp = timestamp;
            this.value = value;
        }

        @Override
        public void accept(SubscriptionEntry entry) {
            entry.update(this.id, this.timestamp, this.value);
        }
    }

    private static class SubscriptionEntry {
        private final Subscription subscription;
        private final int multiple;
        private final ConcurrentHashMap<Id, Consolidator> measurements;

        SubscriptionEntry(Subscription subscription, int multiple) {
            this.subscription = subscription;
            this.multiple = multiple;
            this.measurements = new ConcurrentHashMap();
        }

        void update(Measurement m) {
            this.update(m.id(), m.timestamp(), m.value());
        }

        void update(Id id, long t, double v) {
            Consolidator consolidator = (Consolidator)Utils.computeIfAbsent(this.measurements, (Object)id, k -> Consolidator.create(k, this.subscription.getFrequency(), this.multiple));
            consolidator.update(t, v);
        }
    }
}

