/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.metrics3;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.Snapshot;
import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.DistributionSummary;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicLong;

class MetricsDistributionSummary
implements DistributionSummary {
    private final Clock clock;
    private final Id id;
    private final Histogram impl;
    private final AtomicLong totalAmount;

    MetricsDistributionSummary(Clock clock, Id id, Histogram impl) {
        this.clock = clock;
        this.id = id;
        this.impl = impl;
        this.totalAmount = new AtomicLong(0L);
    }

    public Id id() {
        return this.id;
    }

    public boolean hasExpired() {
        return false;
    }

    public void record(long amount) {
        this.impl.update(amount);
    }

    public Iterable<Measurement> measure() {
        long now = this.clock.wallTime();
        Snapshot snapshot = this.impl.getSnapshot();
        return Collections.singleton(new Measurement(this.id, now, snapshot.getMean()));
    }

    public long count() {
        return this.impl.getCount();
    }

    public long totalAmount() {
        return this.totalAmount.get();
    }
}

