/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.metrics3;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Gauge;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.metrics3.DoubleGauge;
import java.util.Collections;

class MetricsGauge
implements Gauge {
    private final Clock clock;
    private final Id id;
    private final DoubleGauge gauge;

    MetricsGauge(Clock clock, Id id, DoubleGauge gauge) {
        this.clock = clock;
        this.id = id;
        this.gauge = gauge;
    }

    public Id id() {
        return this.id;
    }

    public boolean hasExpired() {
        return false;
    }

    public Iterable<Measurement> measure() {
        return Collections.singleton(new Measurement(this.id, this.clock.wallTime(), this.value()));
    }

    public void set(double v) {
        this.gauge.set(v);
    }

    public double value() {
        return this.gauge.getValue();
    }
}

