/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.metrics3;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.netflix.spectator.api.AbstractRegistry;
import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.DistributionSummary;
import com.netflix.spectator.api.Gauge;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.api.Timer;
import com.netflix.spectator.api.Utils;
import com.netflix.spectator.metrics3.DoubleGauge;
import com.netflix.spectator.metrics3.DoubleMaxGauge;
import com.netflix.spectator.metrics3.MetricsCounter;
import com.netflix.spectator.metrics3.MetricsDistributionSummary;
import com.netflix.spectator.metrics3.MetricsGauge;
import com.netflix.spectator.metrics3.MetricsTimer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class MetricsRegistry
extends AbstractRegistry {
    private final MetricRegistry impl;
    private final Map<String, DoubleGauge> registeredGauges;
    private final Function<Id, String> formatNameFn;

    public MetricsRegistry() {
        this(Clock.SYSTEM, new MetricRegistry());
    }

    public MetricsRegistry(Clock clock, MetricRegistry impl) {
        this(clock, impl, id -> {
            Id normalized = Utils.normalize((Id)id);
            StringBuilder buf = new StringBuilder();
            buf.append(normalized.name());
            for (Tag t : normalized.tags()) {
                buf.append('.').append(t.key()).append('-').append(t.value());
            }
            return buf.toString();
        });
    }

    public MetricsRegistry(Clock clock, MetricRegistry impl, Function<Id, String> formatNameFn) {
        super(clock);
        this.impl = impl;
        this.registeredGauges = new ConcurrentHashMap<String, DoubleGauge>();
        this.formatNameFn = formatNameFn;
    }

    private String toMetricName(Id id) {
        return this.formatNameFn.apply(id);
    }

    protected Counter newCounter(Id id) {
        String name = this.toMetricName(id);
        return new MetricsCounter(this.clock(), id, this.impl.meter(name));
    }

    protected DistributionSummary newDistributionSummary(Id id) {
        String name = this.toMetricName(id);
        return new MetricsDistributionSummary(this.clock(), id, this.impl.histogram(name));
    }

    protected Timer newTimer(Id id) {
        String name = this.toMetricName(id);
        return new MetricsTimer(this.clock(), id, this.impl.timer(name));
    }

    protected Gauge newGauge(Id id) {
        String name = this.toMetricName(id);
        DoubleGauge gauge = this.registeredGauges.computeIfAbsent(name, n -> {
            DoubleGauge g = new DoubleGauge();
            this.impl.register(name, (Metric)g);
            return g;
        });
        return new MetricsGauge(this.clock(), id, gauge);
    }

    protected Gauge newMaxGauge(Id id) {
        String name = this.toMetricName(id);
        DoubleGauge gauge = this.registeredGauges.computeIfAbsent(name, n -> {
            DoubleMaxGauge g = new DoubleMaxGauge();
            this.impl.register(name, (Metric)g);
            return g;
        });
        return new MetricsGauge(this.clock(), id, gauge);
    }
}

