/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.metrics3;

import com.codahale.metrics.Timer;
import com.netflix.spectator.api.AbstractTimer;
import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

class MetricsTimer
extends AbstractTimer {
    private final Id id;
    private final Timer impl;
    private final AtomicLong totalTime;

    MetricsTimer(Clock clock, Id id, Timer impl) {
        super(clock);
        this.id = id;
        this.impl = impl;
        this.totalTime = new AtomicLong(0L);
    }

    public Id id() {
        return this.id;
    }

    public boolean hasExpired() {
        return false;
    }

    public void record(long amount, TimeUnit unit) {
        this.totalTime.addAndGet(unit.toNanos(amount));
        this.impl.update(amount, unit);
    }

    public Iterable<Measurement> measure() {
        long now = this.clock.wallTime();
        return Collections.singleton(new Measurement(this.id, now, this.impl.getMeanRate()));
    }

    public long count() {
        return this.impl.getCount();
    }

    public long totalTime() {
        return this.totalTime.get();
    }
}

