/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.metrics3;

import com.codahale.metrics.Gauge;
import com.netflix.spectator.metrics3.MetricsGauge;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;

class MetricsGaugeAggr
implements Gauge<Double> {
    private ConcurrentLinkedQueue<MetricsGauge> gauges = new ConcurrentLinkedQueue();

    MetricsGaugeAggr() {
    }

    public Double getValue() {
        double aggregatedValue = Double.NaN;
        Iterator<MetricsGauge> iterator = this.gauges.iterator();
        while (iterator.hasNext()) {
            MetricsGauge gauge = iterator.next();
            if (gauge.hasExpired()) {
                iterator.remove();
                continue;
            }
            double gaugeVal = gauge.value();
            if (Double.isNaN(gaugeVal)) continue;
            aggregatedValue = (Double.isNaN(aggregatedValue) ? 0.0 : aggregatedValue) + gaugeVal;
        }
        return aggregatedValue;
    }

    void addGauge(MetricsGauge gauge) {
        this.gauges.add(gauge);
    }
}

