/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.micrometer;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Meter;
import java.util.ArrayList;

abstract class MicrometerMeter
implements Meter {
    private final Id id;

    MicrometerMeter(Id id) {
        this.id = id;
    }

    public Id id() {
        return this.id;
    }

    public boolean hasExpired() {
        return false;
    }

    Iterable<Measurement> convert(Iterable<io.micrometer.core.instrument.Measurement> ms) {
        long now = Clock.SYSTEM.wallTime();
        ArrayList<Measurement> measurements = new ArrayList<Measurement>();
        for (io.micrometer.core.instrument.Measurement m : ms) {
            Id measurementId = this.id.withTag("statistic", m.getStatistic().getTagValueRepresentation());
            measurements.add(new Measurement(measurementId, now, m.getValue()));
        }
        return measurements;
    }
}

