/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.micrometer;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Gauge;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Timer;
import com.netflix.spectator.api.patterns.PolledMeter;
import com.netflix.spectator.impl.AtomicDouble;
import com.netflix.spectator.impl.StepDouble;
import com.netflix.spectator.micrometer.MicrometerClock;
import com.netflix.spectator.micrometer.MicrometerCounter;
import com.netflix.spectator.micrometer.MicrometerDistributionSummary;
import com.netflix.spectator.micrometer.MicrometerGauge;
import com.netflix.spectator.micrometer.MicrometerTimer;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.search.MeterNotFoundException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

public final class MicrometerRegistry
implements Registry {
    private final MeterRegistry impl;
    private final Clock clock;
    private final ConcurrentHashMap<Id, Object> state = new ConcurrentHashMap();

    public MicrometerRegistry(MeterRegistry impl) {
        this.impl = impl;
        this.clock = new MicrometerClock(impl.config().clock());
    }

    private Tag convert(com.netflix.spectator.api.Tag t) {
        return Tag.of((String)t.key(), (String)t.value());
    }

    private Iterable<Tag> convert(Iterable<com.netflix.spectator.api.Tag> tags) {
        ArrayList<Tag> micrometerTags = new ArrayList<Tag>();
        for (com.netflix.spectator.api.Tag t : tags) {
            micrometerTags.add(this.convert(t));
        }
        return micrometerTags;
    }

    private Id convert(Meter.Id id) {
        List tags = id.getTags().stream().map(t -> com.netflix.spectator.api.Tag.of((String)t.getKey(), (String)t.getValue())).collect(Collectors.toList());
        return Id.create((String)id.getName()).withTags(tags);
    }

    private com.netflix.spectator.api.Meter convert(Meter meter) {
        Id id = this.convert(meter.getId());
        if (meter instanceof Counter) {
            return this.counter(id);
        }
        if (meter instanceof io.micrometer.core.instrument.Timer) {
            return this.timer(id);
        }
        if (meter instanceof DistributionSummary) {
            return this.distributionSummary(id);
        }
        if (meter instanceof io.micrometer.core.instrument.Gauge) {
            return this.gauge(id);
        }
        return null;
    }

    public Clock clock() {
        return this.clock;
    }

    public Id createId(String name) {
        return Id.create((String)name);
    }

    public Id createId(String name, Iterable<com.netflix.spectator.api.Tag> tags) {
        return this.createId(name).withTags(tags);
    }

    public void register(com.netflix.spectator.api.Meter meter) {
        PolledMeter.monitorMeter((Registry)this, (com.netflix.spectator.api.Meter)meter);
    }

    public ConcurrentMap<Id, Object> state() {
        return this.state;
    }

    public com.netflix.spectator.api.Counter counter(Id id) {
        return new MicrometerCounter(id, this.impl.counter(id.name(), this.convert(id.tags())));
    }

    public com.netflix.spectator.api.DistributionSummary distributionSummary(Id id) {
        return new MicrometerDistributionSummary(id, this.impl.summary(id.name(), this.convert(id.tags())));
    }

    public Timer timer(Id id) {
        return new MicrometerTimer(id, this.impl.timer(id.name(), this.convert(id.tags())), this.clock);
    }

    public Gauge gauge(Id id) {
        AtomicDouble value = new AtomicDouble(Double.NaN);
        io.micrometer.core.instrument.Gauge gauge = io.micrometer.core.instrument.Gauge.builder((String)id.name(), (Object)value, AtomicDouble::get).tags(this.convert(id.tags())).register(this.impl);
        return new MicrometerGauge(id, arg_0 -> ((AtomicDouble)value).set(arg_0), gauge);
    }

    public Gauge maxGauge(Id id) {
        StepDouble value = new StepDouble(Double.NaN, this.clock(), 60000L);
        io.micrometer.core.instrument.Gauge gauge = io.micrometer.core.instrument.Gauge.builder((String)id.name(), (Object)value, StepDouble::poll).tags(this.convert(id.tags())).register(this.impl);
        return new MicrometerGauge(id, v -> value.getCurrent().max(v), gauge);
    }

    public com.netflix.spectator.api.Meter get(Id id) {
        try {
            return this.impl.get(id.name()).tags(this.convert(id.tags())).meters().stream().filter(m -> id.equals(this.convert(m.getId()))).map(this::convert).filter(Objects::nonNull).findFirst().orElse(null);
        }
        catch (MeterNotFoundException e) {
            return null;
        }
    }

    public Iterator<com.netflix.spectator.api.Meter> iterator() {
        return this.impl.getMeters().stream().map(this::convert).filter(Objects::nonNull).iterator();
    }
}

